/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.jclouds.aws.ec2.ConfigureELBModule;
import org.jclouds.aws.ec2.EC2AsyncClient;
import org.jclouds.aws.ec2.EC2Client;
import org.jclouds.aws.ec2.compute.config.EC2ComputeServiceContextModule;
import org.jclouds.aws.ec2.compute.config.EC2ResolveImagesModule;
import org.jclouds.aws.ec2.config.EC2RestClientModule;
import org.jclouds.compute.ComputeServiceContextBuilder;
import org.jclouds.concurrent.config.ConfiguresExecutorService;
import org.jclouds.http.config.ConfiguresHttpCommandExecutorService;
import org.jclouds.logging.config.LoggingModule;

public class EC2ContextBuilder
extends ComputeServiceContextBuilder<EC2Client, EC2AsyncClient> {
    public EC2ContextBuilder(Properties props) {
        super(EC2Client.class, EC2AsyncClient.class, props);
    }

    public EC2ContextBuilder withModules(Iterable<Module> modules) {
        return (EC2ContextBuilder)super.withModules(modules);
    }

    protected void addContextModule(List<Module> modules) {
        modules.add((Module)new EC2ComputeServiceContextModule());
    }

    protected void addClientModule(List<Module> modules) {
        modules.add((Module)new EC2RestClientModule());
    }

    protected void addImageResolutionModule() {
        this.modules.add(new EC2ResolveImagesModule());
    }

    public Injector buildInjector() {
        try {
            Iterables.find((Iterable)this.modules, (Predicate)Predicates.instanceOf(ConfigureELBModule.class));
        }
        catch (NoSuchElementException e) {
            Iterable infra = Iterables.filter((Iterable)this.modules, (Predicate)new Predicate<Module>(){

                public boolean apply(Module input) {
                    return input.getClass().isAnnotationPresent(ConfiguresExecutorService.class) || input.getClass().isAnnotationPresent(ConfiguresHttpCommandExecutorService.class) || Predicates.instanceOf(LoggingModule.class).apply((Object)input);
                }
            });
            this.modules.add(new ConfigureELBModule(infra, this.properties));
        }
        return super.buildInjector();
    }
}

