/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.io.Closeable;
import java.util.Properties;
import javax.inject.Singleton;
import org.jclouds.aws.elb.ELBClient;
import org.jclouds.lifecycle.Closer;
import org.jclouds.rest.RestContext;
import org.jclouds.rest.RestContextFactory;

public class ConfigureELBModule
extends AbstractModule {
    private final Iterable<Module> infra;
    private final Properties properties;

    ConfigureELBModule(Iterable<Module> infra, Properties properties) {
        this.infra = infra;
        this.properties = properties;
    }

    protected void configure() {
    }

    @Provides
    @Singleton
    ELBClient provideELBClient(Closer closer) {
        final RestContext context = new RestContextFactory().createContext("elb", this.infra, this.properties);
        closer.addToClose(new Closeable(){

            @Override
            public void close() {
                if (context != null) {
                    context.close();
                }
            }
        });
        return (ELBClient)context.getApi();
    }
}

