/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.config;

import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.inject.Singleton;
import org.jclouds.aws.Region;
import org.jclouds.aws.handlers.AWSClientErrorRetryHandler;
import org.jclouds.aws.handlers.AWSRedirectionRetryHandler;
import org.jclouds.aws.handlers.ParseAWSErrorFromXmlContent;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.RequiresHttp;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.logging.Logger;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.annotations.Provider;
import org.jclouds.rest.config.RestClientModule;

@ConfiguresRestClient
@RequiresHttp
public class AWSRestClientModule<S, A>
extends RestClientModule<S, A> {
    public AWSRestClientModule(Class<S> syncClientType, Class<A> asyncClientType, Map<Class<?>, Class<?>> delegates) {
        super(syncClientType, asyncClientType, delegates);
    }

    public AWSRestClientModule(Class<S> syncClientType, Class<A> asyncClientType) {
        super(syncClientType, asyncClientType);
    }

    @Provides
    @Singleton
    @Region
    protected Map<String, URI> provideRegions(Injector injector) {
        String regionString = (String)injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"jclouds.aws.regions")));
        LinkedHashMap regions = Maps.newLinkedHashMap();
        for (String region : Splitter.on((char)',').split((CharSequence)regionString)) {
            regions.put(region, URI.create((String)injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)("jclouds.endpoint." + region))))));
        }
        return regions;
    }

    @Provides
    @Singleton
    @Region
    protected Set<String> provideRegions(@Region Map<String, URI> map) {
        return map.keySet();
    }

    @Provides
    @Singleton
    @Region
    protected String getDefaultRegion(final @Provider URI uri, @Region Map<String, URI> map, Logger.LoggerFactory logFactory) {
        try {
            return (String)((Map.Entry)Iterables.find(map.entrySet(), (Predicate)new Predicate<Map.Entry<String, URI>>(){

                public boolean apply(Map.Entry<String, URI> input) {
                    return input.getValue().equals(uri);
                }
            })).getKey();
        }
        catch (NoSuchElementException e) {
            String region = (String)Iterables.get(map.keySet(), (int)0);
            logFactory.getLogger("jclouds.compute").warn("failed to find region for current endpoint %s in %s; choosing first: %s", new Object[]{uri, map, region});
            return region;
        }
    }

    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(ParseAWSErrorFromXmlContent.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(ParseAWSErrorFromXmlContent.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(ParseAWSErrorFromXmlContent.class);
    }

    protected void bindRetryHandlers() {
        this.bind(HttpRetryHandler.class).annotatedWith(Redirection.class).to(AWSRedirectionRetryHandler.class);
        this.bind(HttpRetryHandler.class).annotatedWith(ClientError.class).to(AWSClientErrorRetryHandler.class);
    }
}

