/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.migration;

import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.StringUtils;
import org.jbpm.migration.Validator;
import org.jbpm.migration.XmlUtils;

public final class JbpmMigration {
    private static final String DEFAULT_XSLT_SHEET = "jpdl3-bpmn2.xsl";

    private JbpmMigration() {
    }

    public static void main(String[] args) throws TransformerException {
        if (args.length == 2) {
            JbpmMigration.transform(args[0], null, args[1]);
        } else if (args.length == 3) {
            JbpmMigration.transform(args[0], args[1], args[2]);
        } else {
            System.err.println("Usage:");
            System.err.println("  java " + JbpmMigration.class.getName() + " jpdlProcessDefinitionFileName xsltFileName outputFileName");
            System.err.println(" or you can use the default jpdl 3.2 transformation:");
            System.err.println("  java " + JbpmMigration.class.getName() + " jpdlProcessDefinitionFileName outputFileName");
            System.exit(1);
        }
    }

    private static void transform(String xmlFileName, String xsltFileName, String outputFileName) {
        StreamSource xsltSource = null;
        xsltSource = StringUtils.isNotBlank((String)xsltFileName) ? new StreamSource(new File(xsltFileName)) : new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream(DEFAULT_XSLT_SHEET));
        StreamSource xmlSource = new StreamSource(new File(xmlFileName));
        StreamResult xmlResult = new StreamResult(new File(outputFileName));
        XmlUtils.transform(xmlSource, xsltSource, xmlResult);
    }

    public static String transform(String inputString) {
        StringWriter outputWriter = new StringWriter();
        StreamSource xsltSource = new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream(DEFAULT_XSLT_SHEET));
        XmlUtils.transform(new StreamSource(new StringReader(inputString)), xsltSource, new StreamResult(outputWriter));
        return outputWriter.toString();
    }

    public static boolean validateJpdl(String inputString) {
        return Validator.validateDefinition(inputString, Validator.ProcessLanguage.JPDL);
    }

    public static boolean validateBpmn(String inputString) {
        return Validator.validateDefinition(inputString, Validator.ProcessLanguage.BPMN);
    }
}

