/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.variables;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jbpm.api.JbpmException;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.listener.EventListener;
import org.jbpm.api.listener.EventListenerExecution;
import org.jbpm.test.JbpmTestCase;

public class HistoryVariableTest
extends JbpmTestCase {
    public void testDeclaredVariableWithHistory() {
        this.deployJpdlXmlString("<process name='var' xmlns='http://jbpm.org/4.4/jpdl'>  <variable name='test' type='string' init-expr='history' history='true'/>  <start nam='a'>    <transition to='b' />  </start>  <state name='b'/></process>");
        this.executionService.startProcessInstanceByKey("var", "one");
        Set variableNames = this.executionService.getVariableNames("var.one");
        HistoryVariableTest.assertEquals((int)1, (int)variableNames.size());
        HistoryVariableTest.assertEquals((String)"test", (String)((String)variableNames.iterator().next()));
        String executionValue = (String)this.executionService.getVariable("var.one", "test");
        HistoryVariableTest.assertEquals((String)"history", (String)executionValue);
        Set historyVariables = this.historyService.getVariableNames("var.one");
        HistoryVariableTest.assertEquals((int)1, (int)historyVariables.size());
        HistoryVariableTest.assertEquals((String)"test", (String)((String)historyVariables.iterator().next()));
        String historyValue = (String)this.historyService.getVariable("var.one", "test");
        HistoryVariableTest.assertEquals((String)"history", (String)historyValue);
    }

    public void testDeclaredVariablesWithHistory() {
        this.deployJpdlXmlString("<process name='var' xmlns='http://jbpm.org/4.4/jpdl'>  <variable name='test' type='string' init-expr='test value' history='true'/>  <variable name='real' type='string' init-expr='real value' history='true'/>  <start name='a'>    <transition to='b' />  </start>  <state name='b'/></process>");
        this.executionService.startProcessInstanceByKey("var", "one");
        Set variableNames = this.executionService.getVariableNames("var.one");
        HistoryVariableTest.assertEquals((int)2, (int)variableNames.size());
        String executionValue = (String)this.executionService.getVariable("var.one", "test");
        HistoryVariableTest.assertEquals((String)"test value", (String)executionValue);
        Set historyVariables = this.historyService.getVariableNames("var.one");
        HistoryVariableTest.assertEquals((int)2, (int)historyVariables.size());
        String historyValue = (String)this.historyService.getVariable("var.one", "real");
        HistoryVariableTest.assertEquals((String)"real value", (String)historyValue);
    }

    public void testCreateVariableWithHistory() {
        this.deployJpdlXmlString("<process name='var' xmlns='http://jbpm.org/4.4/jpdl'>  <start name='a'>    <transition to='b' />  </start>  <state name='b'/></process>");
        this.executionService.startProcessInstanceByKey("var", "one");
        this.executionService.createVariable("var.one", "test2", (Object)"test3", true);
        Set variableNames = this.executionService.getVariableNames("var.one");
        HistoryVariableTest.assertEquals((int)1, (int)variableNames.size());
        HistoryVariableTest.assertEquals((String)"test2", (String)((String)variableNames.iterator().next()));
        String executionValue = (String)this.executionService.getVariable("var.one", "test2");
        HistoryVariableTest.assertEquals((String)"test3", (String)executionValue);
        Set historyVariables = this.historyService.getVariableNames("var.one");
        HistoryVariableTest.assertEquals((int)1, (int)historyVariables.size());
        HistoryVariableTest.assertEquals((String)"test2", (String)((String)historyVariables.iterator().next()));
        String historyValue = (String)this.historyService.getVariable("var.one", "test2");
        HistoryVariableTest.assertEquals((String)"test3", (String)historyValue);
    }

    public void testCreateVariablesWithHistory() {
        this.deployJpdlXmlString("<process name='var' xmlns='http://jbpm.org/4.4/jpdl'>  <start name='a'>    <transition to='b' />  </start>  <state name='b'/></process>");
        this.executionService.startProcessInstanceByKey("var", "one");
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("simple-var", "hello history");
        variables.put("test-var", "good day");
        variables.put("my-var", "cheers");
        this.executionService.createVariables("var.one", variables, true);
        Set variableNames = this.executionService.getVariableNames("var.one");
        HistoryVariableTest.assertEquals((int)3, (int)variableNames.size());
        String executionValue = (String)this.executionService.getVariable("var.one", "test-var");
        HistoryVariableTest.assertEquals((String)"good day", (String)executionValue);
        Set historyVariables = this.historyService.getVariableNames("var.one");
        HistoryVariableTest.assertEquals((int)3, (int)historyVariables.size());
        String historyValue = (String)this.historyService.getVariable("var.one", "simple-var");
        HistoryVariableTest.assertEquals((String)"hello history", (String)historyValue);
    }

    public void testDeclaredVariablesMixed() {
        this.deployJpdlXmlString("<process name='var' xmlns='http://jbpm.org/4.4/jpdl'>  <variable name='test' type='string' init-expr='test value' history='true'/>  <variable name='real' type='string' init-expr='real value' history='false'/>  <start name='a'>    <transition to='b' />  </start>  <state name='b'/></process>");
        this.executionService.startProcessInstanceByKey("var", "one");
        Set variableNames = this.executionService.getVariableNames("var.one");
        HistoryVariableTest.assertEquals((int)2, (int)variableNames.size());
        String executionValue = (String)this.executionService.getVariable("var.one", "test");
        HistoryVariableTest.assertEquals((String)"test value", (String)executionValue);
        Set historyVariables = this.historyService.getVariableNames("var.one");
        HistoryVariableTest.assertEquals((int)1, (int)historyVariables.size());
        String historyValue = (String)this.historyService.getVariable("var.one", "test");
        HistoryVariableTest.assertEquals((String)"test value", (String)historyValue);
        HistoryVariableTest.assertNull((Object)this.historyService.getVariable("var.one", "real"));
    }

    public void testDeclaredIntegerVariableWithHistory() {
        this.deployJpdlXmlString("<process name='var' xmlns='http://jbpm.org/4.4/jpdl'>  <variable name='test' type='integer' init-expr='#{testV}' history='true'/>  <start name='a'>    <transition to='b' />  </start>  <state name='b'/></process>");
        Map<String, Integer> vars = Collections.singletonMap("testV", 35);
        this.executionService.startProcessInstanceByKey("var", vars, "one");
        Set variableNames = this.executionService.getVariableNames("var.one");
        HistoryVariableTest.assertEquals((int)2, (int)variableNames.size());
        HistoryVariableTest.assertEquals((String)"test", (String)((String)variableNames.iterator().next()));
        Integer executionValue = (Integer)this.executionService.getVariable("var.one", "test");
        HistoryVariableTest.assertEquals((int)35, (int)executionValue);
        Set historyVariables = this.historyService.getVariableNames("var.one");
        HistoryVariableTest.assertEquals((int)1, (int)historyVariables.size());
        HistoryVariableTest.assertEquals((String)"test", (String)((String)historyVariables.iterator().next()));
        String historyValue = (String)this.historyService.getVariable("var.one", "test");
        HistoryVariableTest.assertEquals((String)"35", (String)historyValue);
    }

    public void testDeclaredSerializableVariableWithHistory() {
        this.deployJpdlXmlString("<process name='var' xmlns='http://jbpm.org/4.4/jpdl'>  <variable name='test' type='serializable' history='true'>    <object class='java.util.Date'>      <constructor><arg><long value='1276086573250'/></arg></constructor>    </object>  </variable>  <start name='a'>    <transition to='b' />  </start>  <state name='b'/></process>");
        this.executionService.startProcessInstanceByKey("var", "one");
        Set variableNames = this.executionService.getVariableNames("var.one");
        HistoryVariableTest.assertEquals((int)1, (int)variableNames.size());
        HistoryVariableTest.assertEquals((String)"test", (String)((String)variableNames.iterator().next()));
        Date variableValue = (Date)this.executionService.getVariable("var.one", "test");
        HistoryVariableTest.assertEquals((long)1276086573250L, (long)variableValue.getTime());
        Set historyVariables = this.historyService.getVariableNames("var.one");
        HistoryVariableTest.assertEquals((int)1, (int)historyVariables.size());
        HistoryVariableTest.assertEquals((String)"test", (String)((String)historyVariables.iterator().next()));
        String historyValue = (String)this.historyService.getVariable("var.one", "test");
        HistoryVariableTest.assertEquals((String)variableValue.toString(), (String)historyValue);
    }

    public void testDeclaredVariableWithHistoryWrongProcessInstanceId() {
        this.deployJpdlXmlString("<process name='var' xmlns='http://jbpm.org/4.4/jpdl'>  <variable name='test' type='string' init-expr='history' history='true'/>  <start name='a'>    <transition to='b' />  </start>  <state name='b'/></process>");
        this.executionService.startProcessInstanceByKey("var", "one");
        Set variableNames = this.executionService.getVariableNames("var.one");
        HistoryVariableTest.assertEquals((int)1, (int)variableNames.size());
        HistoryVariableTest.assertEquals((String)"test", (String)((String)variableNames.iterator().next()));
        String executionValue = (String)this.executionService.getVariable("var.one", "test");
        HistoryVariableTest.assertEquals((String)"history", (String)executionValue);
        Set historyVariables = this.historyService.getVariableNames("var.one");
        HistoryVariableTest.assertEquals((int)1, (int)historyVariables.size());
        HistoryVariableTest.assertEquals((String)"test", (String)((String)historyVariables.iterator().next()));
        String wrongProcessInstanceId = "var.one.1";
        try {
            this.historyService.getVariable(wrongProcessInstanceId, "test");
            HistoryVariableTest.fail((String)"should fail since it uses wrong process instance id");
        }
        catch (JbpmException e) {
            String message = e.getMessage();
            HistoryVariableTest.assertTrue((String)message, (boolean)message.contains(wrongProcessInstanceId));
        }
    }

    public void testDeclaredVariableWithHistoryWrongProcess() {
        this.deployJpdlXmlString("<process name='var' xmlns='http://jbpm.org/4.4/jpdl'>  <variable name='test' type='string' init-expr='history' history='true'/>  <start name='a'>    <transition to='b' />  </start>  <state name='b'/></process>");
        this.executionService.startProcessInstanceByKey("var", "one");
        Set variableNames = this.executionService.getVariableNames("var.one");
        HistoryVariableTest.assertEquals((int)1, (int)variableNames.size());
        HistoryVariableTest.assertEquals((String)"test", (String)((String)variableNames.iterator().next()));
        String executionValue = (String)this.executionService.getVariable("var.one", "test");
        HistoryVariableTest.assertEquals((String)"history", (String)executionValue);
        try {
            this.historyService.getVariables(null, null);
            HistoryVariableTest.fail((String)"should fail since process instance id is null");
        }
        catch (JbpmException e) {
            HistoryVariableTest.assertEquals((String)"processInstanceId is null", (String)e.getMessage());
        }
        try {
            this.historyService.getVariables("var.one", null);
            HistoryVariableTest.fail((String)"should fail since variable names set is null");
        }
        catch (JbpmException e) {
            HistoryVariableTest.assertEquals((String)"variableNames is null", (String)e.getMessage());
        }
    }

    public void testDeclaredVariableWithHistoryAndUpdateBySignal() {
        this.deployJpdlXmlString("<process name='var' xmlns='http://jbpm.org/4.4/jpdl'>  <variable name='test' type='integer' init-expr='#{testV}' history='true'/>  <start name='a'>    <transition to='b' />  </start>  <state name='b'>    <transition to='c' />  </state>  <state name='c'/></process>");
        Map<String, Integer> vars = Collections.singletonMap("testV", 35);
        ProcessInstance pi = this.executionService.startProcessInstanceByKey("var", vars, "one");
        Set variableNames = this.executionService.getVariableNames("var.one");
        HistoryVariableTest.assertEquals((int)2, (int)variableNames.size());
        HistoryVariableTest.assertEquals((String)"test", (String)((String)variableNames.iterator().next()));
        Integer executionValue = (Integer)this.executionService.getVariable("var.one", "test");
        HistoryVariableTest.assertEquals((int)35, (int)executionValue);
        this.executionService.signalExecutionById(pi.getId(), Collections.singletonMap("test", 55));
        Set historyVariables = this.historyService.getVariableNames("var.one");
        HistoryVariableTest.assertEquals((int)1, (int)historyVariables.size());
        HistoryVariableTest.assertEquals((String)"test", (String)((String)historyVariables.iterator().next()));
        String historyValue = (String)this.historyService.getVariable("var.one", "test");
        HistoryVariableTest.assertEquals((String)"55", (String)historyValue);
    }

    public void testDeclaredVariableWithHistoryAndUpdateByExecService() {
        this.deployJpdlXmlString("<process name='var' xmlns='http://jbpm.org/4.4/jpdl'>  <variable name='test' type='integer' init-expr='#{testV}' history='true'/>  <start name='a'>    <transition to='b' />  </start>  <state name='b'>    <transition to='c' />  </state>  <state name='c'/></process>");
        Map<String, Integer> vars = Collections.singletonMap("testV", 35);
        ProcessInstance pi = this.executionService.startProcessInstanceByKey("var", vars, "one");
        Set variableNames = this.executionService.getVariableNames("var.one");
        HistoryVariableTest.assertEquals((int)2, (int)variableNames.size());
        HistoryVariableTest.assertEquals((String)"test", (String)((String)variableNames.iterator().next()));
        Integer executionValue = (Integer)this.executionService.getVariable("var.one", "test");
        HistoryVariableTest.assertEquals((int)35, (int)executionValue);
        this.executionService.setVariable(pi.getId(), "test", (Object)55);
        this.executionService.signalExecutionById(pi.getId());
        Set historyVariables = this.historyService.getVariableNames("var.one");
        HistoryVariableTest.assertEquals((int)1, (int)historyVariables.size());
        HistoryVariableTest.assertEquals((String)"test", (String)((String)historyVariables.iterator().next()));
        String historyValue = (String)this.historyService.getVariable("var.one", "test");
        HistoryVariableTest.assertEquals((String)"55", (String)historyValue);
    }

    public void testDeclaredSerializableVariableWithHistoryAndUpdateByExecService() {
        this.deployJpdlXmlString("<process name='var' xmlns='http://jbpm.org/4.4/jpdl'>  <variable name='test' type='serializable' history='true'>    <object class='" + SetVariableListener.class.getName() + "'>" + "    </object>" + "  </variable>" + "  <start name='a'>" + "    <transition to='b' />" + "  </start>" + "  <state name='b'>" + "    <transition to='c' />" + "  </state>" + "  <state name='c'/>" + "</process>");
        Map<String, Integer> vars = Collections.singletonMap("testV", 35);
        ProcessInstance pi = this.executionService.startProcessInstanceByKey("var", vars, "one");
        Set variableNames = this.executionService.getVariableNames("var.one");
        HistoryVariableTest.assertEquals((int)2, (int)variableNames.size());
        HistoryVariableTest.assertEquals((String)"test", (String)((String)variableNames.iterator().next()));
        SetVariableListener executionValue = (SetVariableListener)this.executionService.getVariable("var.one", "test");
        HistoryVariableTest.assertEquals((String)"test value", (String)executionValue.toString());
        SetVariableListener newInstance = new SetVariableListener();
        newInstance.setSimpleValue("value test");
        this.executionService.setVariable(pi.getId(), "test", (Object)newInstance);
        this.executionService.signalExecutionById(pi.getId());
        Set historyVariables = this.historyService.getVariableNames("var.one");
        HistoryVariableTest.assertEquals((int)1, (int)historyVariables.size());
        HistoryVariableTest.assertEquals((String)"test", (String)((String)historyVariables.iterator().next()));
        String historyValue = (String)this.historyService.getVariable("var.one", "test");
        HistoryVariableTest.assertEquals((String)"value test", (String)historyValue);
    }

    public void testDeclaredVariableWithHistoryAndUpdateByEvent() {
        this.deployJpdlXmlString("<process name='var' xmlns='http://jbpm.org/4.4/jpdl'>  <variable name='test' type='integer' init-expr='#{testV}' history='true'/>  <start name='a'>    <transition to='b' />  </start>  <state name='b'>    <on event='end'>      <event-listener class='" + SetVariableListener.class.getName() + "' />" + "    </on>" + "    <transition to='c' />" + "  </state>" + "  <state name='c'/>" + "</process>");
        Map<String, Integer> vars = Collections.singletonMap("testV", 35);
        ProcessInstance pi = this.executionService.startProcessInstanceByKey("var", vars, "one");
        Set variableNames = this.executionService.getVariableNames("var.one");
        HistoryVariableTest.assertEquals((int)2, (int)variableNames.size());
        HistoryVariableTest.assertEquals((String)"test", (String)((String)variableNames.iterator().next()));
        Integer executionValue = (Integer)this.executionService.getVariable("var.one", "test");
        HistoryVariableTest.assertEquals((int)35, (int)executionValue);
        this.executionService.signalExecutionById(pi.getId());
        Set historyVariables = this.historyService.getVariableNames("var.one");
        HistoryVariableTest.assertEquals((int)1, (int)historyVariables.size());
        HistoryVariableTest.assertEquals((String)"test", (String)((String)historyVariables.iterator().next()));
        String historyValue = (String)this.historyService.getVariable("var.one", "test");
        HistoryVariableTest.assertEquals((String)"55", (String)historyValue);
    }

    public static class SetVariableListener
    implements EventListener {
        private String simpleValue = "test value";
        private static final long serialVersionUID = 1L;

        public void notify(EventListenerExecution execution) {
            execution.setVariable("test", (Object)55);
        }

        public void setSimpleValue(String value) {
            this.simpleValue = value;
        }

        public String toString() {
            return this.simpleValue;
        }
    }
}

