/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.variables;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.List;
import org.codehaus.janino.Compiler;
import org.codehaus.janino.DebuggingInformation;
import org.codehaus.janino.util.StringPattern;
import org.codehaus.janino.util.enumerator.EnumeratorSet;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;

public class DeserializeVariableTest
extends JbpmTestCase {
    String deploymentId;

    protected void setUp() throws Exception {
        super.setUp();
        this.generateBeanClass();
        this.deploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/test/variables/DeserializeTaskTest.jpdl.xml").addResourceFromInputStream("org/jbpm/test/variables/Bean.class", (InputStream)new FileInputStream(new File("target/generated/org/jbpm/test/variables/Bean.class"))).deploy();
    }

    protected void tearDown() throws Exception {
        this.repositoryService.deleteDeploymentCascade(this.deploymentId);
        super.tearDown();
    }

    public void testDeserializeVariable() {
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("DeserializeTaskTest");
        String processInstanceId = processInstance.getId();
        List tasks = this.taskService.findPersonalTasks("alex");
        DeserializeVariableTest.assertTrue((tasks.size() == 1 ? 1 : 0) != 0);
        Task task = (Task)tasks.get(0);
        DeserializeVariableTest.assertNotNull((Object)this.taskService.getVariable(task.getId(), "bean"));
        DeserializeVariableTest.assertNotNull((Object)this.executionService.getVariable(processInstanceId, "bean"));
        this.taskService.completeTask(task.getId());
    }

    public void generateBeanClass() {
        this.log.debug("Inside generateBeanClass method");
        File directory = new File("target/generated/org/jbpm/test/variables");
        if (!directory.exists()) {
            this.log.debug("No generated class directory, about to create source file");
            try {
                directory.mkdirs();
                File sourceFile = new File(directory, "Bean.java");
                FileWriter writer = new FileWriter(sourceFile);
                StringBuffer source = new StringBuffer();
                source.append("package org.jbpm.test.variables;\n");
                source.append("import java.io.Serializable;\n");
                source.append("public class Bean implements Serializable {\n");
                source.append("private static final long serialVersionUID = -5510563444135221777L;\n");
                source.append("  private String value;\n");
                source.append("  public Bean getResult() {\n");
                source.append("    this.value = \"test\";\n");
                source.append("        return this;\n");
                source.append("  }\n");
                source.append("}\n");
                writer.write(source.toString());
                writer.close();
                this.log.debug("Source file create in " + directory.getAbsolutePath());
                File destinationDirectory = Compiler.NO_DESTINATION_DIRECTORY;
                File[] optionalSourcePath = null;
                File[] classPath = new File[]{new File(".")};
                File[] optionalExtDirs = null;
                File[] optionalBootClassPath = null;
                String optionalCharacterEncoding = null;
                boolean verbose = false;
                EnumeratorSet debuggingInformation = DebuggingInformation.DEFAULT_DEBUGGING_INFORMATION;
                StringPattern[] warningHandlePatterns = Compiler.DEFAULT_WARNING_HANDLE_PATTERNS;
                boolean rebuild = false;
                this.log.debug("About to run Janinio compiler");
                Compiler javac = new Compiler(optionalSourcePath, classPath, optionalExtDirs, optionalBootClassPath, destinationDirectory, optionalCharacterEncoding, verbose, debuggingInformation, warningHandlePatterns, rebuild);
                javac.compile(new File[]{sourceFile});
                this.log.debug("Class compiled successfully");
            }
            catch (Exception e) {
                this.log.error("Error while creating additional resources", (Throwable)e);
            }
        }
    }
}

