/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.timer;

import java.util.List;
import org.jbpm.api.Execution;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.history.HistoryTask;
import org.jbpm.api.job.Job;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;

public class TaskTimerTaskTest
extends JbpmTestCase {
    public void testTaskClosedWhenTimerFires() {
        this.deployJpdlXmlString("<process name='TaskTimer'>  <start name='start'>    <transition to='do work' />  </start>  <task name='do work' assignee='johndoe'>    <transition name='done' to='go home' />    <transition name='lunch' to='go to cafeteria'>      <timer duedate='10 seconds' />    </transition>  </task>  <state name='go home' />  <state name='go to cafeteria' /></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("TaskTimer");
        List tasks = this.taskService.createTaskQuery().assignee("johndoe").list();
        TaskTimerTaskTest.assertEquals((int)1, (int)tasks.size());
        Job timer = this.managementService.createJobQuery().processInstanceId(processInstance.getId()).timers().uniqueResult();
        TaskTimerTaskTest.assertNotNull((Object)timer);
        this.managementService.executeJob(timer.getId());
        this.assertActivityActive(processInstance.getId(), "go to cafeteria");
        TaskTimerTaskTest.assertEquals((int)0, (int)this.taskService.createTaskQuery().assignee("johndoe").list().size());
        String taskId = ((Task)tasks.get(0)).getId();
        List history = this.historyService.createHistoryTaskQuery().taskId(taskId).list();
        TaskTimerTaskTest.assertEquals((int)1, (int)history.size());
        TaskTimerTaskTest.assertEquals((String)"obsolete", (String)((HistoryTask)history.get(0)).getState());
    }

    public void testTaskClosedBySignal() {
        this.deployJpdlXmlString("<process name='TaskTimer'>  <start name='start'>    <transition to='do work' />  </start>  <task name='do work' assignee='johndoe'>    <transition name='done' to='go home' />    <transition name='lunch' to='go to cafeteria'>      <timer duedate='10 seconds' />    </transition>  </task>  <state name='go home' />  <state name='go to cafeteria' /></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("TaskTimer");
        List tasks = this.taskService.createTaskQuery().assignee("johndoe").list();
        TaskTimerTaskTest.assertEquals((int)1, (int)tasks.size());
        Execution exec = processInstance.findActiveExecutionIn("do work");
        processInstance = this.executionService.signalExecutionById(exec.getId(), "done");
        this.assertActivityActive(processInstance.getId(), "go home");
        TaskTimerTaskTest.assertEquals((int)0, (int)this.taskService.createTaskQuery().assignee("johndoe").list().size());
        String taskId = ((Task)tasks.get(0)).getId();
        List history = this.historyService.createHistoryTaskQuery().taskId(taskId).list();
        TaskTimerTaskTest.assertEquals((int)1, (int)history.size());
        TaskTimerTaskTest.assertEquals((String)"obsolete", (String)((HistoryTask)history.get(0)).getState());
    }
}

