/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.task;

import java.util.List;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;

public class TaskListTest
extends JbpmTestCase {
    public void testPersonalTaskList() {
        Task task = this.taskService.newTask();
        task.setName("do laundry");
        task.setAssignee("johndoe");
        String laundryTaskId = this.taskService.saveTask(task);
        task = this.taskService.newTask();
        task.setName("get good idea");
        task.setAssignee("joesmoe");
        String ideaTaskId = this.taskService.saveTask(task);
        task = this.taskService.newTask();
        task.setName("find venture capital");
        task.setAssignee("joesmoe");
        String capitalTaskId = this.taskService.saveTask(task);
        task = this.taskService.newTask();
        task.setName("start new business");
        task.setAssignee("joesmoe");
        String startBusinessTaskId = this.taskService.saveTask(task);
        List taskList = this.taskService.findPersonalTasks("johndoe");
        TaskListTest.assertNotNull((Object)taskList);
        TaskListTest.assertEquals((String)"do laundry", (String)((Task)taskList.get(0)).getName());
        TaskListTest.assertEquals((int)1, (int)taskList.size());
        taskList = this.taskService.findPersonalTasks("joesmoe");
        TaskListTest.assertNotNull((Object)taskList);
        TaskListTest.assertContainsTask((List)taskList, (String)"get good idea");
        TaskListTest.assertContainsTask((List)taskList, (String)"start new business");
        TaskListTest.assertContainsTask((List)taskList, (String)"find venture capital");
        TaskListTest.assertEquals((int)3, (int)taskList.size());
        this.taskService.deleteTaskCascade(startBusinessTaskId);
        this.taskService.deleteTaskCascade(capitalTaskId);
        this.taskService.deleteTaskCascade(ideaTaskId);
        this.taskService.deleteTaskCascade(laundryTaskId);
    }

    public void testPersonalTaskListDefaultSortOrder() {
        Task task = this.taskService.newTask();
        task.setName("get good idea");
        task.setAssignee("joesmoe");
        task.setPriority(3);
        String ideaTaskId = this.taskService.saveTask(task);
        task = this.taskService.newTask();
        task.setName("find venture capital");
        task.setAssignee("joesmoe");
        task.setPriority(2);
        String capitalTaskId = this.taskService.saveTask(task);
        task = this.taskService.newTask();
        task.setName("start new business");
        task.setAssignee("joesmoe");
        task.setPriority(1);
        String startBusinessTaskId = this.taskService.saveTask(task);
        task = this.taskService.newTask();
        task.setName("take a day off");
        task.setAssignee("joesmoe");
        task.setPriority(-5);
        String dayOffTaskId = this.taskService.saveTask(task);
        task = this.taskService.newTask();
        task.setName("make profit");
        task.setAssignee("joesmoe");
        task.setPriority(10);
        String profitTaskId = this.taskService.saveTask(task);
        List taskList = this.taskService.findPersonalTasks("joesmoe");
        TaskListTest.assertNotNull((Object)taskList);
        TaskListTest.assertEquals((String)"make profit", (String)((Task)taskList.get(0)).getName());
        TaskListTest.assertEquals((String)"get good idea", (String)((Task)taskList.get(1)).getName());
        TaskListTest.assertEquals((String)"find venture capital", (String)((Task)taskList.get(2)).getName());
        TaskListTest.assertEquals((String)"start new business", (String)((Task)taskList.get(3)).getName());
        TaskListTest.assertEquals((String)"take a day off", (String)((Task)taskList.get(4)).getName());
        TaskListTest.assertEquals((int)5, (int)taskList.size());
        this.taskService.deleteTaskCascade(profitTaskId);
        this.taskService.deleteTaskCascade(dayOffTaskId);
        this.taskService.deleteTaskCascade(startBusinessTaskId);
        this.taskService.deleteTaskCascade(capitalTaskId);
        this.taskService.deleteTaskCascade(ideaTaskId);
    }
}

