/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.reporting;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.TestCase;
import org.hibernate.cfg.Configuration;
import org.jbpm.test.reporting.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLStmtTest
extends TestCase {
    private static final String OVERALL_ACTIVITY_RPTDESIGN = "overall_activity.rptdesign";
    private static final String PROCESS_SUMMARY_RPTDESIGN = "process_summary.rptdesign";
    private Connection conn;
    static boolean skipTests;

    protected void setUp() throws Exception {
        Properties jdbcProps = new Configuration().configure("jbpm.hibernate.cfg.xml").getProperties();
        Class.forName(jdbcProps.getProperty("hibernate.connection.driver_class"));
        this.conn = DriverManager.getConnection(jdbcProps.getProperty("hibernate.connection.url"), jdbcProps.getProperty("hibernate.connection.username"), jdbcProps.getProperty("hibernate.connection.password"));
    }

    protected void tearDown() throws Exception {
        if (this.conn != null) {
            this.conn.close();
        }
    }

    public void testOverallActivityReport_Statements() throws Exception {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(OVERALL_ACTIVITY_RPTDESIGN);
        SQLStmtTest.assertNotNull((String)"Unable to find report:overall_activity.rptdesign", (Object)in);
        Document doc = this.parseTemplate(in);
        List<Element> queryTextElements = this.getQueryTextElements(doc);
        SQLStmtTest.assertFalse((String)"No query strings found in template", (boolean)queryTextElements.isEmpty());
        for (Element query : queryTextElements) {
            this.executeQuery(query.getTextContent());
        }
    }

    public void testProcessSummaryReport_Statements() throws Exception {
        if (skipTests) {
            return;
        }
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(PROCESS_SUMMARY_RPTDESIGN);
        SQLStmtTest.assertNotNull((String)"Unable to find report:process_summary.rptdesign", (Object)in);
        Document doc = this.parseTemplate(in);
        List<Element> queryTextElements = this.getQueryTextElements(doc);
        SQLStmtTest.assertFalse((String)"No query strings found in template", (boolean)queryTextElements.isEmpty());
        for (Element query : queryTextElements) {
            this.executeQuery(query.getTextContent());
        }
    }

    private void executeQuery(String sql) throws SQLException {
        System.out.println("Execute:");
        System.out.println(sql);
        PreparedStatement stmt = this.conn.prepareStatement(sql);
        ParameterMetaData metaData = stmt.getParameterMetaData();
        for (int i = 1; i < metaData.getParameterCount() + 1; ++i) {
            stmt.setString(i, "PLACEHOLDER_STRING");
        }
        ResultSet rs = stmt.executeQuery();
        System.out.println("");
        System.out.println("Result size:" + rs.getFetchSize());
        System.out.println("--");
    }

    private List<Element> getQueryTextElements(Document doc) {
        ArrayList<Element> props = new ArrayList<Element>();
        SQLStmtTest.dfsElementSearch(props, doc.getDocumentElement(), new Filter(){

            public boolean select(Element candidate) {
                return candidate.getNodeName().equals("property") && DOMUtils.getAttributeValue(candidate, "name").equals("queryText");
            }
        });
        return props;
    }

    private Document parseTemplate(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(in);
        return doc;
    }

    private static void dfsElementSearch(List<Element> resultBuffer, Element root, Filter filter) {
        if (filter.select(root)) {
            resultBuffer.add(root);
            return;
        }
        List<Element> children = SQLStmtTest.getChildElements(root);
        for (Element child : children) {
            SQLStmtTest.dfsElementSearch(resultBuffer, child, filter);
        }
    }

    private static List<Element> getChildElements(Node node) {
        LinkedList<Element> list = new LinkedList<Element>();
        NodeList nlist = node.getChildNodes();
        for (int i = 0; i < nlist.getLength(); ++i) {
            Node child = nlist.item(i);
            if (child.getNodeType() != 1) continue;
            list.add((Element)child);
        }
        return list;
    }

    static interface Filter {
        public boolean select(Element var1);
    }
}

