/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.query;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.jbpm.api.TaskQuery;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.assertion.QueryAssertions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskQueryTest
extends JbpmTestCase {
    public void testPropertyNames() {
        Task task = this.taskService.newTask();
        task.setName("write task query test");
        task.setAssignee("koen");
        task.setPriority(Integer.MAX_VALUE);
        task.setDescription("make sure the test fails if property names are incorrect");
        task.setDuedate(new Date());
        String taskId = this.taskService.saveTask(task);
        this.checkProperty(this.taskService.createTaskQuery(), task, "assignee");
        this.checkProperty(this.taskService.createTaskQuery(), task, "createTime");
        this.checkProperty(this.taskService.createTaskQuery(), task, "duedate");
        this.checkProperty(this.taskService.createTaskQuery(), task, "name");
        this.checkProperty(this.taskService.createTaskQuery(), task, "priority");
        this.checkProperty(this.taskService.createTaskQuery(), task, "progress");
        this.taskService.deleteTaskCascade(taskId);
    }

    private void checkProperty(TaskQuery taskQuery, Task task, String propertyName) {
        List taskList = taskQuery.orderAsc(propertyName).list();
        TaskQueryTest.assertNotNull((Object)taskList);
        TaskQueryTest.assertContainsTask((List)taskList, (String)task.getName());
        TaskQueryTest.assertEquals((int)1, (int)taskList.size());
    }

    public void testSimplestTaskQuery() {
        List<Task> tasks = this.createTestTasks();
        List taskList = this.taskService.createTaskQuery().list();
        TaskQueryTest.assertNotNull((Object)taskList);
        TaskQueryTest.assertContainsTask((List)taskList, (String)"do laundry");
        TaskQueryTest.assertContainsTask((List)taskList, (String)"change dyper");
        TaskQueryTest.assertContainsTask((List)taskList, (String)"start new business");
        TaskQueryTest.assertContainsTask((List)taskList, (String)"find venture capital");
        TaskQueryTest.assertEquals((int)4, (int)taskList.size());
        this.deleteTasks(tasks);
    }

    public void testOrderByName() {
        this.testOrderBy("name", "change dyper", "do laundry", "find venture capital", "start new business");
    }

    public void testOrderByAssignee() {
        this.testOrderBy("assignee", "Alex", "Joram", "Koen", "Tom");
    }

    public void testOrderByCreateTime() {
        this.testOrderByResultsInNaturalOrdening("createTime", 4);
    }

    public void testOrderByDueDate() {
        this.testOrderByResultsInNaturalOrdening("duedate", 4);
    }

    public void testOrderByPriority() {
        this.testOrderByResultsInNaturalOrdening("priority", 4);
    }

    public void testOrderByProgress() {
        this.testOrderBy("progress", 2, 15, 75, 99);
    }

    public void testCount() {
        ArrayList<Task> tasks = new ArrayList<Task>();
        String assignee = "task1";
        for (int i = 0; i < 30; ++i) {
            Task task = this.taskService.newTask();
            if (i % 2 == 0) {
                task.setAssignee("task1");
            }
            this.taskService.saveTask(task);
            tasks.add(task);
        }
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        TaskQueryTest.assertEquals((long)30L, (long)taskQuery.count());
        TaskQueryTest.assertEquals((long)15L, (long)taskQuery.assignee("task1").count());
        this.deleteTasks(tasks);
    }

    private List<Task> createTestTasks() {
        ArrayList<Task> result = new ArrayList<Task>();
        Task task1 = this.taskService.newTask();
        task1.setName("do laundry");
        task1.setAssignee("Tom");
        task1.setPriority(3);
        task1.setDuedate(this.stringToDate("10/10/1985"));
        task1.setProgress(Integer.valueOf(15));
        Task task2 = this.taskService.newTask();
        task2.setName("change dyper");
        task2.setAssignee("Koen");
        task2.setPriority(1);
        task2.setDuedate(this.stringToDate("28/06/1989"));
        task2.setProgress(Integer.valueOf(2));
        Task task3 = this.taskService.newTask();
        task3.setName("start new business");
        task3.setAssignee("Joram");
        task3.setPriority(4);
        task3.setProgress(Integer.valueOf(75));
        Task task4 = this.taskService.newTask();
        task4.setName("find venture capital");
        task4.setAssignee("Alex");
        task4.setPriority(7);
        task4.setDuedate(this.stringToDate("09/09/2009"));
        task4.setProgress(Integer.valueOf(99));
        for (Task t : new Task[]{task1, task2, task3, task4}) {
            this.taskService.saveTask(t);
            result.add(t);
        }
        return result;
    }

    private void testOrderBy(String property, Object ... expectedValues) {
        List<Task> tasks = this.createTestTasks();
        List taskListAsc = this.taskService.createTaskQuery().orderAsc(property).list();
        List taskListDesc = this.taskService.createTaskQuery().orderDesc(property).list();
        QueryAssertions.assertOrderOnProperty(Task.class, (String)property, (List)taskListAsc, (List)taskListDesc, Arrays.asList(expectedValues));
        this.deleteTasks(tasks);
    }

    private void testOrderByResultsInNaturalOrdening(String property, int expectedNrOfResults) {
        List<Task> tasks = this.createTestTasks();
        List taskListAsc = this.taskService.createTaskQuery().orderAsc(property).list();
        List taskListDesc = this.taskService.createTaskQuery().orderDesc(property).list();
        QueryAssertions.assertOrderIsNatural(Task.class, (String)property, (List)taskListAsc, (List)taskListDesc, (int)expectedNrOfResults);
        this.deleteTasks(tasks);
    }

    private void deleteTasks(List<Task> tasks) {
        for (Task t : tasks) {
            this.taskService.deleteTaskCascade(t.getId());
        }
    }

    private Date stringToDate(String dateString) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/mm/yyyy");
        try {
            return dateFormat.parse(dateString);
        }
        catch (ParseException e) {
            throw new RuntimeException("Couldn't convert " + dateString);
        }
    }
}

