/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.query;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.jbpm.api.ProcessDefinition;
import org.jbpm.api.history.HistoryProcessInstance;
import org.jbpm.pvm.internal.util.Clock;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.assertion.QueryAssertions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryProcessInstanceQueryTest
extends JbpmTestCase {
    public void testQueryByProcessInstanceId() {
        List<String> procInstIds = this.createTestHistoryProcessInstances(4);
        for (String processInstanceId : procInstIds) {
            HistoryProcessInstanceQueryTest.assertNotNull((Object)this.historyService.createHistoryProcessInstanceQuery().processInstanceId(processInstanceId).uniqueResult());
        }
    }

    public void testQueryByProcessDefinitionId() {
        this.createTestHistoryProcessInstances(5);
        ProcessDefinition processDefinition = this.repositoryService.createProcessDefinitionQuery().uniqueResult();
        HistoryProcessInstanceQueryTest.assertEquals((int)5, (int)this.historyService.createHistoryProcessInstanceQuery().processDefinitionId(processDefinition.getId()).list().size());
    }

    public void testQueryByBusinessKey() {
        int nrOfInstances = 3;
        this.createTestHistoryProcessInstances(3);
        for (int i = 0; i < 3; ++i) {
            HistoryProcessInstanceQueryTest.assertNotNull((Object)this.historyService.createHistoryProcessInstanceQuery().processInstanceKey("theProcess-" + i).uniqueResult());
        }
    }

    public void testCount() {
        List<String> procInstIds = this.createTestHistoryProcessInstances(7);
        HistoryProcessInstanceQueryTest.assertEquals((long)0L, (long)this.historyService.createHistoryProcessInstanceQuery().processDefinitionId("-1").count());
        HistoryProcessInstanceQueryTest.assertEquals((long)7L, (long)this.historyService.createHistoryProcessInstanceQuery().count());
        for (String id : procInstIds) {
            HistoryProcessInstanceQueryTest.assertEquals((long)1L, (long)this.historyService.createHistoryProcessInstanceQuery().processInstanceId(id).count());
        }
    }

    public void testOrderByStartTime() {
        this.testOrderByNaturalOrdening("startTime", 4);
    }

    public void testOrderByEndTime() {
        this.testOrderByNaturalOrdening("endTime", 4);
    }

    public void testOrderByDuration() {
        this.testOrderByNaturalOrdening("duration", 4);
    }

    public void testQueryEnded() {
        List<String> procInstIds = this.createTestHistoryProcessInstances(4);
        String endedProcInstId = procInstIds.get(0);
        this.executionService.endProcessInstance(endedProcInstId, "ended");
        List procInsts = this.historyService.createHistoryProcessInstanceQuery().ended().list();
        HistoryProcessInstanceQueryTest.assertEquals((int)1, (int)procInsts.size());
        HistoryProcessInstance endedProcInst = (HistoryProcessInstance)procInsts.get(0);
        HistoryProcessInstanceQueryTest.assertEquals((String)endedProcInstId, (String)endedProcInst.getProcessInstanceId());
    }

    public void testQueryEndedBefore() {
        List<String> procInstIds = this.createTestHistoryProcessInstances(4);
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        Date yesterday = calendar.getTime();
        Clock.setExplicitTime((Date)yesterday);
        String endedYesterdayProcInstId = procInstIds.get(0);
        this.executionService.endProcessInstance(endedYesterdayProcInstId, "ended");
        calendar.add(5, -1);
        Date twoDaysAgo = calendar.getTime();
        Clock.setExplicitTime((Date)twoDaysAgo);
        String endedTwoDaysAgoProcInstId = procInstIds.get(1);
        this.executionService.endProcessInstance(endedTwoDaysAgoProcInstId, "ended");
        List procInsts = this.historyService.createHistoryProcessInstanceQuery().endedBefore(yesterday).list();
        HistoryProcessInstanceQueryTest.assertEquals((int)1, (int)procInsts.size());
        HistoryProcessInstance endedTwoDaysAgoProcInst = (HistoryProcessInstance)procInsts.get(0);
        HistoryProcessInstanceQueryTest.assertEquals((String)endedTwoDaysAgoProcInstId, (String)endedTwoDaysAgoProcInst.getProcessInstanceId());
        Clock.setExplicitTime(null);
    }

    public void testQueryEndedAfter() {
        List<String> procInstIds = this.createTestHistoryProcessInstances(4);
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        Date yesterday = calendar.getTime();
        Clock.setExplicitTime((Date)yesterday);
        String endedYesterdayProcInstId = procInstIds.get(0);
        this.executionService.endProcessInstance(endedYesterdayProcInstId, "ended");
        calendar.add(5, -1);
        Date twoDaysAgo = calendar.getTime();
        Clock.setExplicitTime((Date)twoDaysAgo);
        String endedTwoDaysAgoProcInstId = procInstIds.get(1);
        this.executionService.endProcessInstance(endedTwoDaysAgoProcInstId, "ended");
        List procInsts = this.historyService.createHistoryProcessInstanceQuery().endedAfter(yesterday).list();
        HistoryProcessInstanceQueryTest.assertEquals((int)1, (int)procInsts.size());
        HistoryProcessInstance endedYesterdayProcInst = (HistoryProcessInstance)procInsts.get(0);
        HistoryProcessInstanceQueryTest.assertEquals((String)endedYesterdayProcInstId, (String)endedYesterdayProcInst.getProcessInstanceId());
        Clock.setExplicitTime(null);
    }

    public void testQueryEndedAfterAndBefore() {
        List<String> procInstIds = this.createTestHistoryProcessInstances(4);
        String endedTodayProcInstId = procInstIds.get(0);
        this.executionService.endProcessInstance(endedTodayProcInstId, "ended");
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        Date yesterday = calendar.getTime();
        Clock.setExplicitTime((Date)yesterday);
        String endedYesterdayProcInstId = procInstIds.get(1);
        this.executionService.endProcessInstance(endedYesterdayProcInstId, "ended");
        calendar.add(5, -1);
        Date twoDaysAgo = calendar.getTime();
        Clock.setExplicitTime((Date)twoDaysAgo);
        String endedTwoDaysAgoProcInstId = procInstIds.get(2);
        this.executionService.endProcessInstance(endedTwoDaysAgoProcInstId, "ended");
        calendar.add(5, 3);
        Date tomorrow = calendar.getTime();
        List procInsts = this.historyService.createHistoryProcessInstanceQuery().endedAfter(yesterday).endedBefore(tomorrow).list();
        HistoryProcessInstanceQueryTest.assertEquals((int)2, (int)procInsts.size());
        for (HistoryProcessInstance procInst : procInsts) {
            String procInstId = procInst.getProcessInstanceId();
            assert (procInstId.equals(endedYesterdayProcInstId) || procInstId.equals(endedTodayProcInstId)) : procInstId;
        }
        Clock.setExplicitTime(null);
    }

    private void testOrderBy(String property, List<Object> expectedValues) {
        this.createTestHistoryProcessInstances(4);
        List histProcListAsc = this.historyService.createHistoryProcessInstanceQuery().orderAsc(property).list();
        List histProcListDesc = this.historyService.createHistoryProcessInstanceQuery().orderDesc(property).list();
        QueryAssertions.assertOrderOnProperty(HistoryProcessInstance.class, (String)property, (List)histProcListAsc, (List)histProcListDesc, expectedValues);
    }

    private void testOrderByNaturalOrdening(String property, int expectedNrOfResults) {
        this.createTestHistoryProcessInstances(4);
        List histProcListAsc = this.historyService.createHistoryProcessInstanceQuery().orderAsc(property).list();
        List histProcListDesc = this.historyService.createHistoryProcessInstanceQuery().orderDesc(property).list();
        QueryAssertions.assertOrderIsNatural(HistoryProcessInstance.class, (String)property, (List)histProcListAsc, (List)histProcListDesc, (int)expectedNrOfResults);
    }

    private List<String> createTestHistoryProcessInstances(int nrOfInstances) {
        this.deployJpdlXmlString("<process name='theProcess'>  <start>    <transition to='wait' />  </start>  <state name='wait'>    <transition to='end' />  </state>  <end name='end' /></process>");
        ArrayList<String> procInstIds = new ArrayList<String>();
        for (int i = 0; i < nrOfInstances; ++i) {
            procInstIds.add(this.executionService.startProcessInstanceByKey("theProcess", "theProcess-" + i).getId());
        }
        return procInstIds;
    }
}

