/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.identity;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jbpm.api.JbpmException;
import org.jbpm.api.identity.Group;
import org.jbpm.api.identity.User;
import org.jbpm.test.JbpmTestCase;

public class IdentityTest
extends JbpmTestCase {
    public void testSingleUser() throws Exception {
        this.identityService.createUser("johndoe", "John", "Doe");
        User user = this.identityService.findUserById("johndoe");
        IdentityTest.assertEquals((String)"johndoe", (String)user.getId());
        IdentityTest.assertEquals((String)"John", (String)user.getGivenName());
        IdentityTest.assertEquals((String)"Doe", (String)user.getFamilyName());
        this.identityService.deleteUser("johndoe");
    }

    public void testCreateGroup() throws Exception {
        String testGroupId = this.identityService.createGroup("testGroup", "unit", null);
        Group group = this.identityService.findGroupById(testGroupId);
        IdentityTest.assertEquals((String)"testGroup", (String)group.getName());
        IdentityTest.assertEquals((String)"unit", (String)group.getType());
        this.identityService.deleteGroup(testGroupId);
    }

    public void testFindGroupsByUser() throws Exception {
        String redhatGroupId = this.identityService.createGroup("redhat", "unit", null);
        this.identityService.createUser("jeffyu", "Jeff", "Yu");
        this.identityService.createMembership("jeffyu", redhatGroupId);
        List groups = this.identityService.findGroupsByUser("jeffyu");
        HashSet<String> groupNames = new HashSet<String>();
        for (Group group : groups) {
            groupNames.add(group.getName());
        }
        IdentityTest.assertEquals(Collections.singleton("redhat"), groupNames);
        this.identityService.deleteUser("jeffyu");
        this.identityService.deleteGroup(redhatGroupId);
    }

    public void testFindGroupByUserAndGroupType() throws Exception {
        this.identityService.createUser("johndoe", "John", "Doe");
        String redhatGroupId = this.identityService.createGroup("redhat", "unit", null);
        this.identityService.createMembership("johndoe", redhatGroupId, "developer");
        List groups = this.identityService.findGroupsByUserAndGroupType("johndoe", "unit");
        HashSet<String> groupNames = new HashSet<String>();
        for (Group group : groups) {
            groupNames.add(group.getName());
        }
        IdentityTest.assertEquals(Collections.singleton("redhat"), groupNames);
        this.identityService.deleteUser("johndoe");
        this.identityService.deleteGroup(redhatGroupId);
    }

    public void testSingleGroup() throws Exception {
        this.identityService.createUser("johndoe", "John", "Doe");
        this.identityService.createUser("joesmoe", "Joe", "Smoe");
        this.identityService.createUser("jackblack", "Jack", "Black");
        String redhatGroupId = this.identityService.createGroup("redhat", "unit", null);
        String jbossId = this.identityService.createGroup("jboss", "unit", redhatGroupId);
        String jbpmId = this.identityService.createGroup("jbpm", "unit", jbossId);
        this.identityService.createMembership("johndoe", redhatGroupId, "developer");
        this.identityService.createMembership("joesmoe", jbpmId, "leader");
        this.identityService.createMembership("jackblack", jbossId, "manager");
        List groups = this.identityService.findGroupsByUserAndGroupType("johndoe", "unit");
        IdentityTest.assertEquals((int)1, (int)groups.size());
        Group group = (Group)groups.get(0);
        IdentityTest.assertEquals((String)"redhat", (String)group.getName());
        this.identityService.deleteGroup(jbpmId);
        this.identityService.deleteGroup(jbossId);
        this.identityService.deleteGroup(redhatGroupId);
        this.identityService.deleteUser("johndoe");
        this.identityService.deleteUser("joesmoe");
        this.identityService.deleteUser("jackblack");
    }

    public void testSingleUser2() throws Exception {
        this.identityService.createUser("johndoe", "John", "Doe");
        List users = this.identityService.findUsers();
        IdentityTest.assertNotNull((Object)users);
        User johndoe = null;
        for (User user : users) {
            if (!"johndoe".equals(user.getId())) continue;
            johndoe = user;
        }
        IdentityTest.assertNotNull(johndoe);
        IdentityTest.assertEquals((String)"johndoe", (String)johndoe.getId());
        IdentityTest.assertEquals((String)"John", (String)johndoe.getGivenName());
        IdentityTest.assertEquals((String)"Doe", (String)johndoe.getFamilyName());
        IdentityTest.assertEquals((String)"John Doe", (String)johndoe.toString());
        this.identityService.deleteUser("johndoe");
    }

    public void testDuplicatedUser() {
        this.identityService.createUser("johndoe", "John", "Doe");
        try {
            this.identityService.createUser("johndoe", "John", "Doe");
            IdentityTest.fail((String)"shouldn't allow duplicated user");
        }
        catch (JbpmException ex) {
            IdentityTest.assertEquals((String)"Cannot create user, error while validating", (String)ex.getMessage());
        }
        this.identityService.deleteUser("johndoe");
    }

    public void testDuplicatedGroup() {
        this.identityService.createGroup("group");
        try {
            this.identityService.createGroup("group");
            IdentityTest.fail((String)"shouldn't allow duplicated group");
        }
        catch (JbpmException ex) {
            IdentityTest.assertEquals((String)"Cannot create group, error while validating", (String)ex.getMessage());
        }
        this.identityService.deleteGroup("group");
    }
}

