/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.execution;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jbpm.api.JbpmException;
import org.jbpm.api.ProcessInstance;
import org.jbpm.test.JbpmTestCase;

public class StartExecutionTest
extends JbpmTestCase {
    public void testNonExistentProcessKey() {
        try {
            this.executionService.startProcessInstanceByKey("MeaningOfLife");
            StartExecutionTest.fail((String)"expected exception");
        }
        catch (JbpmException e) {
            this.assertTextPresent("no process definition with key 'MeaningOfLife'", e.getMessage());
        }
    }

    public void testNonExistentProcessId() {
        try {
            this.executionService.startProcessInstanceById("MeaningOfLife");
            StartExecutionTest.fail((String)"expected exception");
        }
        catch (JbpmException e) {
            this.assertTextPresent("no process definition with id 'MeaningOfLife'", e.getMessage());
        }
    }

    public void testStartNewExecutionByKey() {
        this.deployJpdlXmlString("<process name='Insurance claim' key='ICL'>  <start>    <transition to='a' />  </start>  <state name='a' /></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("ICL");
        StartExecutionTest.assertNotNull((Object)processInstance);
        StartExecutionTest.assertTrue((boolean)processInstance.isActive("a"));
    }

    public void testStartNewExecutionInLatestProcessDefinition() {
        this.deployJpdlXmlString("<process name='Insurance claim' key='ICL'>  <start>    <transition to='a' />  </start>  <state name='a' /></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("ICL");
        StartExecutionTest.assertNotNull((Object)processInstance);
        StartExecutionTest.assertTrue((boolean)processInstance.isActive("a"));
        this.deployJpdlXmlString("<process name='Insurance claim' key='ICL'>  <start>    <transition to='b' />  </start>  <state name='b' /></process>");
        processInstance = this.executionService.startProcessInstanceByKey("ICL");
        StartExecutionTest.assertNotNull((Object)processInstance);
        StartExecutionTest.assertTrue((boolean)processInstance.isActive("b"));
    }

    public void testStartExecutionInLatestByNameWithVariables() {
        this.deployJpdlXmlString("<process name='Insurance claim' key='ICL'>  <start>    <transition to='a' />  </start>  <state name='a' /></process>");
        this.deployJpdlXmlString("<process name='Insurance claim' key='ICL'>  <start>    <transition to='b' />  </start>  <state name='b' /></process>");
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("a", new Integer(1));
        variables.put("b", "text");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("ICL", variables);
        String executionId = processInstance.getId();
        StartExecutionTest.assertTrue((boolean)processInstance.isActive("b"));
        StartExecutionTest.assertEquals((Object)new Integer(1), (Object)this.executionService.getVariable(executionId, "a"));
        StartExecutionTest.assertEquals((Object)"text", (Object)this.executionService.getVariable(executionId, "b"));
        StartExecutionTest.assertTrue((boolean)processInstance.getId().startsWith("ICL."));
    }

    public void testStartNewProcessInstanceWithAKey() {
        this.deployJpdlXmlString("<process name='Insurance claim' key='ICL'>  <start>    <transition to='a' />  </start>  <state name='a' /></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("ICL", "one");
        StartExecutionTest.assertNotNull((Object)processInstance);
        StartExecutionTest.assertEquals((String)"ICL.one", (String)processInstance.getId());
    }

    public void testStartNewProcessInstanceWithVariables() {
        this.deployJpdlXmlString("<process name='Insurance claim' key='ICL'>  <start>    <transition to='a' />  </start>  <state name='a' /></process>");
        Map<String, Object> variables = new HashMap<String, Object>();
        variables.put("customer", "John Doe");
        variables.put("type", "Accident");
        variables.put("amount", new Float(763.74));
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("ICL", variables);
        String executionId = processInstance.getId();
        StartExecutionTest.assertNotNull((Object)processInstance);
        HashMap expectedVariables = new HashMap(variables);
        HashSet expectedVariableNames = new HashSet(expectedVariables.keySet());
        HashSet variableNames = new HashSet(this.executionService.getVariableNames(executionId));
        StartExecutionTest.assertEquals(expectedVariableNames, variableNames);
        variables = this.executionService.getVariables(executionId, variableNames);
        StartExecutionTest.assertEquals(expectedVariables, variables);
    }

    public void testStartExecutionById() {
        this.deployJpdlXmlString("<process name='Insurance claim' key='ICL'>  <start>    <transition to='a' />  </start>  <state name='a' /></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceById("ICL-1");
        StartExecutionTest.assertNotNull((Object)processInstance);
        StartExecutionTest.assertTrue((boolean)processInstance.isActive("a"));
        StartExecutionTest.assertNull((Object)processInstance.getName());
        StartExecutionTest.assertNull((Object)processInstance.getKey());
        StartExecutionTest.assertTrue((boolean)processInstance.getId().startsWith("ICL."));
        Long.parseLong(processInstance.getId().substring(4));
    }

    public void testStartExecutionByIdWithVariables() {
        this.deployJpdlXmlString("<process name='Insurance claim' key='ICL'>  <start>    <transition to='a' />  </start>  <state name='a' /></process>");
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("a", new Integer(1));
        variables.put("b", "text");
        ProcessInstance processInstance = this.executionService.startProcessInstanceById("ICL-1", variables);
        String executionId = processInstance.getId();
        StartExecutionTest.assertEquals((Object)new Integer(1), (Object)this.executionService.getVariable(executionId, "a"));
        StartExecutionTest.assertEquals((Object)"text", (Object)this.executionService.getVariable(executionId, "b"));
    }
}

