/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.eventlistener;

import java.util.HashSet;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;

public class HqlEventListenerTest
extends JbpmTestCase {
    String taskLaundryId;
    String taskDishesId;
    String taskIronId;

    protected void setUp() throws Exception {
        super.setUp();
        Task task = this.taskService.newTask();
        task.setName("laundry");
        this.taskLaundryId = this.taskService.saveTask(task);
        task = this.taskService.newTask();
        task.setName("dishes");
        this.taskDishesId = this.taskService.saveTask(task);
        task = this.taskService.newTask();
        task.setName("iron");
        this.taskIronId = this.taskService.saveTask(task);
    }

    protected void tearDown() throws Exception {
        this.taskService.deleteTaskCascade(this.taskLaundryId);
        this.taskService.deleteTaskCascade(this.taskDishesId);
        this.taskService.deleteTaskCascade(this.taskIronId);
        super.tearDown();
    }

    public void testHql() {
        this.deployJpdlXmlString("<process name='HqlEventListener'>  <start >    <transition to='wait' />  </start>  <state name='wait'>    <on event='start'>      <hql var='tasknames with i'>        <query>          select task.name          from org.jbpm.pvm.internal.task.TaskImpl as task          where task.name like :taskName        </query>        <parameters>          <string name='taskName' value='%i%' />        </parameters>      </hql>    </on>  </state></process>");
        ProcessInstance execution = this.executionService.startProcessInstanceByKey("HqlEventListener");
        String executionId = execution.getId();
        HashSet<String> expectedTaskNames = new HashSet<String>();
        expectedTaskNames.add("dishes");
        expectedTaskNames.add("iron");
        HashSet taskNames = (HashSet)this.executionService.getVariable(executionId, "tasknames with i");
        taskNames = new HashSet(taskNames);
        HqlEventListenerTest.assertEquals(expectedTaskNames, taskNames);
    }
}

