/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.eventlistener;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.listener.EventListener;
import org.jbpm.api.listener.EventListenerExecution;
import org.jbpm.test.JbpmTestCase;

public class EventListenerTest
extends JbpmTestCase {
    public void testProcessStartListener() {
        this.deployJpdlXmlString("<process name='Insurance claim' key='ICL'>  <on event='start'>    <event-listener class='" + ProcessStartListener.class.getName() + "' />" + "  </on>" + "  <start>" + "    <transition to='a' />" + "  </start>" + "  <state name='a' />" + "</process>");
        String processInstanceId = this.executionService.startProcessInstanceByKey("ICL").getId();
        EventListenerTest.assertEquals((Object)"true", (Object)this.executionService.getVariable(processInstanceId, "isInvoked"));
        this.executionService.setVariable(processInstanceId, "isInvoked", (Object)"false");
        this.executionService.signalExecutionById(processInstanceId);
        EventListenerTest.assertEquals((Object)"false", (Object)this.executionService.getVariable(processInstanceId, "isInvoked"));
    }

    public void testProcessStartListenerPropagation() {
        this.deployJpdlXmlString("<process name='Insurance claim' key='ICL'>  <on event='start'>    <event-listener propagation='enabled' class='" + PropagationEnabledListener.class.getName() + "' />" + "  </on>" + "  <start>" + "    <transition to='a' />" + "  </start>" + "  <state name='a'>" + "    <transition to='b' />" + "  </state>" + "  <state name='b' />" + "</process>");
        String processInstanceId = this.executionService.startProcessInstanceByKey("ICL").getId();
        EventListenerTest.assertEquals((Object)2, (Object)this.executionService.getVariable(processInstanceId, "invocations"));
        this.executionService.signalExecutionById(processInstanceId);
        EventListenerTest.assertEquals((Object)3, (Object)this.executionService.getVariable(processInstanceId, "invocations"));
    }

    public void testActivityStartListener() {
        this.deployJpdlXmlString("<process name='Insurance claim' key='ICL'>  <start>    <transition to='s' />  </start>  <state name='s'>    <on event='start'>      <event-listener class='" + ActivityStartListener.class.getName() + "' />" + "    </on>" + "    <transition to='end' />" + "  </state>" + "  <state name='end' />" + "</process>");
        String processInstanceId = this.executionService.startProcessInstanceByKey("ICL").getId();
        EventListenerTest.assertEquals((Object)"true", (Object)this.executionService.getVariable(processInstanceId, "isInvoked"));
    }

    public void testActivityEndListener() {
        this.deployJpdlXmlString("<process name='Insurance claim' key='ICL'>  <start>    <transition to='s' />  </start>  <state name='s'>    <on event='end'>      <event-listener class='" + ActivityEndListener.class.getName() + "' />" + "    </on>" + "    <transition to='end' />" + "  </state>" + "  <state name='end' />" + "</process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("ICL");
        String processInstanceId = processInstance.getId();
        EventListenerTest.assertNull((Object)this.executionService.getVariable(processInstanceId, "isInvoked"));
        this.executionService.signalExecutionById(processInstance.getId());
        EventListenerTest.assertEquals((Object)"true", (Object)this.executionService.getVariable(processInstanceId, "isInvoked"));
    }

    public void testTransitionListener() {
        this.deployJpdlXmlString("<process name='Insurance claim' key='ICL'>  <start>    <transition to='end'>      <event-listener class='" + TransitionListener.class.getName() + "' />" + "    </transition>" + "  </start>" + "  <state name='end' />" + "</process>");
        String processInstanceId = this.executionService.startProcessInstanceByKey("ICL").getId();
        EventListenerTest.assertEquals((Object)"true", (Object)this.executionService.getVariable(processInstanceId, "isInvoked"));
    }

    public void testEventOrdering() {
        this.deployJpdlXmlString("<process name='Insurance claim' key='ICL'>  <start>    <transition to='end'>      <event-listener class='" + OrderListener.class.getName() + "'>" + "        <field name='i'><int value='1' /></field> " + "      </event-listener>" + "      <event-listener class='" + OrderListener.class.getName() + "'>" + "        <field name='i'><int value='2' /></field> " + "      </event-listener>" + "      <event-listener class='" + OrderListener.class.getName() + "'>" + "        <field name='i'><int value='3' /></field> " + "      </event-listener>" + "      <event-listener class='" + OrderListener.class.getName() + "'>" + "        <field name='i'><int value='4' /></field> " + "      </event-listener>" + "      <event-listener class='" + OrderListener.class.getName() + "'>" + "        <field name='i'><int value='5' /></field> " + "      </event-listener>" + "    </transition>" + "  </start>" + "  <state name='end' />" + "</process>");
        HashMap variables = new HashMap();
        variables.put("order", new ArrayList());
        String processInstanceId = this.executionService.startProcessInstanceByKey("ICL", variables).getId();
        ArrayList<Integer> expectedOrder = new ArrayList<Integer>();
        expectedOrder.add(1);
        expectedOrder.add(2);
        expectedOrder.add(3);
        expectedOrder.add(4);
        expectedOrder.add(5);
        EventListenerTest.assertEquals(expectedOrder, (Object)this.executionService.getVariable(processInstanceId, "order"));
    }

    public void testProcessStartListenerExpr() {
        this.deployJpdlXmlString("<process name='Insurance claim' key='ICL'>  <on event='start'>    <event-listener expr='#{processstartlistener}' />  </on>  <start>    <transition to='a' />  </start>  <state name='a' /></process>");
        HashMap<String, ProcessStartListener> variables = new HashMap<String, ProcessStartListener>();
        variables.put("processstartlistener", new ProcessStartListener());
        String processInstanceId = this.executionService.startProcessInstanceByKey("ICL", variables).getId();
        EventListenerTest.assertEquals((Object)"true", (Object)this.executionService.getVariable(processInstanceId, "isInvoked"));
        this.executionService.setVariable(processInstanceId, "isInvoked", (Object)"false");
        this.executionService.signalExecutionById(processInstanceId);
        EventListenerTest.assertEquals((Object)"false", (Object)this.executionService.getVariable(processInstanceId, "isInvoked"));
    }

    public void testActivityStartListenerExpr() {
        this.deployJpdlXmlString("<process name='Insurance claim' key='ICL'>  <start>    <transition to='s' />  </start>  <state name='s'>    <on event='start'>      <event-listener expr='#{activitystartlistener}' />    </on>    <transition to='end' />  </state>  <state name='end' /></process>");
        HashMap<String, ActivityStartListener> variables = new HashMap<String, ActivityStartListener>();
        variables.put("activitystartlistener", new ActivityStartListener());
        String processInstanceId = this.executionService.startProcessInstanceByKey("ICL", variables).getId();
        EventListenerTest.assertEquals((Object)"true", (Object)this.executionService.getVariable(processInstanceId, "isInvoked"));
    }

    public void testActivityEndListenerExpr() {
        this.deployJpdlXmlString("<process name='Insurance claim' key='ICL'>  <start>    <transition to='s' />  </start>  <state name='s'>    <on event='end'>      <event-listener expr='#{activityendlistener}' />    </on>    <transition to='end' />  </state>  <state name='end' /></process>");
        HashMap<String, ActivityEndListener> variables = new HashMap<String, ActivityEndListener>();
        variables.put("activityendlistener", new ActivityEndListener());
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("ICL", variables);
        String processInstanceId = processInstance.getId();
        EventListenerTest.assertNull((Object)this.executionService.getVariable(processInstanceId, "isInvoked"));
        this.executionService.signalExecutionById(processInstance.getId());
        EventListenerTest.assertEquals((Object)"true", (Object)this.executionService.getVariable(processInstanceId, "isInvoked"));
    }

    public static class OrderListener
    implements EventListener {
        private static final long serialVersionUID = 1L;
        int i;

        public void notify(EventListenerExecution execution) {
            List order = (List)execution.getVariable("order");
            order.add(this.i);
            execution.setVariable("order", (Object)order);
        }
    }

    public static class TransitionListener
    implements EventListener {
        private static final long serialVersionUID = 1L;

        public void notify(EventListenerExecution execution) {
            execution.setVariable("isInvoked", (Object)"true");
        }
    }

    public static class ActivityEndListener
    implements EventListener {
        private static final long serialVersionUID = 1L;

        public void notify(EventListenerExecution execution) {
            execution.setVariable("isInvoked", (Object)"true");
        }
    }

    public static class ActivityStartListener
    implements EventListener {
        private static final long serialVersionUID = 1L;

        public void notify(EventListenerExecution execution) {
            execution.setVariable("isInvoked", (Object)"true");
        }
    }

    public static class PropagationEnabledListener
    implements EventListener {
        private static final long serialVersionUID = 1L;

        public void notify(EventListenerExecution execution) {
            Integer invocations = (Integer)execution.getVariable("invocations");
            if (invocations == null) {
                execution.setVariable("invocations", (Object)1);
            } else {
                execution.setVariable("invocations", (Object)(invocations + 1));
            }
        }
    }

    public static class ProcessStartListener
    implements EventListener {
        private static final long serialVersionUID = 1L;

        public void notify(EventListenerExecution execution) {
            execution.setVariable("isInvoked", (Object)"true");
        }
    }
}

