/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.activity.forkjoin;

import java.util.Set;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.listener.EventListener;
import org.jbpm.api.listener.EventListenerExecution;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.test.JbpmTestCase;

public class ForkResultsInNullEndActivityTest
extends JbpmTestCase {
    public static final String XML_FORK_JOIN = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process name=\"ForkTest\" xmlns=\"http://jbpm.org/4.3/jpdl\">\n  <start name=\"preparing test\">\n    <on event='end'>      <event-listener class='org.jbpm.test.activity.forkjoin.ForkResultsInNullEndActivityTest$StartEventListener'/>    </on>    <transition to=\"fork\"/>\n  </start>\n  <fork name=\"fork\">\n    <transition to=\"state1\"/>\n    <transition to=\"state2\"/>\n    <transition to=\"cancel\"/>\n  </fork>\n  <state name=\"cancel\">\n    <transition to=\"cancelled\"/>\n  </state>\n  <state name=\"state1\">\n    <transition to=\"states completed\"/>\n  </state>\n  <state name=\"state2\">\n    <transition to=\"states completed\"/>\n  </state>\n  <join multiplicity=\"2\" name=\"states completed\">\n    <transition to=\"completed\"/>\n  </join>\n  <end name=\"cancelled\"/>\n  <end name=\"completed\"/>\n</process>";
    public static final String XML_SUB_PROCESS = "<process name='sub_process' xmlns='http://jbpm.org/4.3/jpdl'>  <start>    <transition to='sub'/>  </start>  <sub-process name='sub' sub-process-key='ForkTest' outcome='#{result}'>    <transition name='to A' to='A'/>    <transition name='to B' to='B'/>    <transition name='to C' to='C'/>  </sub-process>  <state name='A'/>  <state name='B'/>  <state name='C'/></process>";
    private String deploymentId;

    protected void setUp() throws Exception {
        super.setUp();
        this.deploymentId = this.repositoryService.createDeployment().addResourceFromString("ForkTest.jpdl.xml", XML_FORK_JOIN).addResourceFromString("sub_process.jpdl.xml", XML_SUB_PROCESS).deploy();
    }

    protected void tearDown() throws Exception {
        this.repositoryService.deleteDeploymentCascade(this.deploymentId);
        super.tearDown();
    }

    private void verifyInitialActivities(ProcessInstance proc) {
        String[] expectedStartActivities = new String[]{"state1", "state2", "cancel"};
        Set foundStartActivities = proc.findActiveActivityNames();
        for (String act : expectedStartActivities) {
            ForkResultsInNullEndActivityTest.assertTrue((boolean)foundStartActivities.contains(act));
        }
    }

    public void t2estCompleteJoin() {
        ProcessInstance proc = this.executionService.startProcessInstanceByKey("ForkTest");
        this.verifyInitialActivities(proc);
        String state1Id = proc.findActiveExecutionIn("state1").getId();
        proc = this.executionService.signalExecutionById(state1Id);
        String state2Id = proc.findActiveExecutionIn("state2").getId();
        proc = this.executionService.signalExecutionById(state2Id);
        this.assertExecutionEnded(proc.getId());
        ExecutionImpl executionImpl = (ExecutionImpl)proc;
        ForkResultsInNullEndActivityTest.assertEquals((String)"completed", (String)executionImpl.getActivityName());
        ForkResultsInNullEndActivityTest.assertEquals((String)"completed", (String)this.historyService.createHistoryProcessInstanceQuery().uniqueResult().getEndActivityName());
    }

    public void t2estCancelWithoutJoin() {
        ProcessInstance proc = this.executionService.startProcessInstanceByKey("ForkTest");
        this.verifyInitialActivities(proc);
        String driveTruckExecutionId = proc.findActiveExecutionIn("cancel").getId();
        proc = this.executionService.signalExecutionById(driveTruckExecutionId);
        this.assertExecutionEnded(proc.getId());
        ExecutionImpl executionImpl = (ExecutionImpl)proc;
        ForkResultsInNullEndActivityTest.assertEquals((String)"cancelled", (String)executionImpl.getActivityName());
        ForkResultsInNullEndActivityTest.assertEquals((String)"cancelled", (String)this.historyService.createHistoryProcessInstanceQuery().uniqueResult().getEndActivityName());
    }

    public void testForkAndSubProcess() {
        ProcessInstance mainProcess = this.executionService.startProcessInstanceByKey("sub_process");
        ProcessInstance subProcess = this.executionService.createProcessInstanceQuery().orderDesc("dbid").page(0, 1).uniqueResult();
        String driveTruckExecutionId = subProcess.findActiveExecutionIn("cancel").getId();
        subProcess = this.executionService.signalExecutionById(driveTruckExecutionId);
        mainProcess = this.executionService.findProcessInstanceById(mainProcess.getId());
        ForkResultsInNullEndActivityTest.assertEquals((String)"A", (String)((String)mainProcess.findActiveActivityNames().iterator().next()));
    }

    public static class StartEventListener
    implements EventListener {
        public void notify(EventListenerExecution execution) {
            execution.setVariable("result", (Object)"to A");
        }
    }
}

