/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.activity.assign;

import java.util.Collections;
import java.util.Map;
import org.jbpm.api.ProcessInstance;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.activity.assign.Person;

public class AssignTest
extends JbpmTestCase {
    public void testFromExprToVar() {
        this.deployJpdlXmlString("<process name='AssignTest' xmlns='http://jbpm.org/4.4/jpdl'>  <start>    <transition to='resolve' />  </start>  <assign name='resolve' from-expr='#{person.name}' to-var='result'>    <transition to='wait' />  </assign>  <state name='wait' /></process>");
        Person person = new Person();
        person.setName("johndoe");
        Map<String, Person> variables = Collections.singletonMap("person", person);
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("AssignTest", variables);
        AssignTest.assertEquals((Object)"johndoe", (Object)this.executionService.getVariable(processInstance.getId(), "result"));
    }

    public void testFromMethodExprToVar() {
        this.deployJpdlXmlString("<process name='AssignTest' xmlns='http://jbpm.org/4.4/jpdl'>  <start>    <transition to='resolve' />  </start>  <assign name='resolve' from-expr='#{person.toString()}' to-var='result'>    <transition to='wait' />  </assign>  <state name='wait' /></process>");
        Person person = new Person();
        person.setName("johndoe");
        Map<String, Person> variables = Collections.singletonMap("person", person);
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("AssignTest", variables);
        AssignTest.assertEquals((Object)"Person(johndoe)", (Object)this.executionService.getVariable(processInstance.getId(), "result"));
    }

    public void testFromMethodParamExprToVar() {
        this.deployJpdlXmlString("<process name='AssignTest' xmlns='http://jbpm.org/4.4/jpdl'>  <start>    <transition to='resolve' />  </start>  <assign name='resolve' from-expr=\"#{person.sayHi('Joe')}\" to-var='result'>    <transition to='wait' />  </assign>  <state name='wait' /></process>");
        Person person = new Person();
        person.setName("johndoe");
        Map<String, Person> variables = Collections.singletonMap("person", person);
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("AssignTest", variables);
        AssignTest.assertEquals((Object)"Hi, Joe", (Object)this.executionService.getVariable(processInstance.getId(), "result"));
    }

    public void testFromDescToExpr() {
        this.deployJpdlXmlString("<process name='AssignTest' xmlns='http://jbpm.org/4.4/jpdl'>  <start>    <transition to='resolve' />  </start>  <assign name='resolve' to-expr='#{person.address.street}'>    <from><string value='gasthuisstraat' /></from>    <transition to='wait' />  </assign>  <state name='wait' /></process>");
        Person person = new Person();
        person.setName("johndoe");
        Map<String, Person> variables = Collections.singletonMap("person", person);
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("AssignTest", variables);
        person = (Person)this.executionService.getVariable(processInstance.getId(), "person");
        AssignTest.assertEquals((String)"gasthuisstraat", (String)person.getAddress().getStreet());
    }

    public void testFromVarToVar() {
        this.deployJpdlXmlString("<process name='AssignTest' xmlns='http://jbpm.org/4.4/jpdl'>  <start>    <transition to='resolve' />  </start>  <assign name='resolve' from-var='person' to-var='result'>    <transition to='wait' />  </assign>  <state name='wait' /></process>");
        Person person = new Person();
        person.setName("johndoe");
        Map<String, Person> variables = Collections.singletonMap("person", person);
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("AssignTest", variables);
        person = (Person)this.executionService.getVariable(processInstance.getId(), "result");
        AssignTest.assertEquals((String)"johndoe", (String)person.getName());
    }
}

