/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.group.concurrency;

import org.jbpm.api.ProcessInstance;
import org.jbpm.test.JbpmTestCase;

public class GroupConcurrencyTest
extends JbpmTestCase {
    String deploymentId;

    protected void setUp() throws Exception {
        super.setUp();
        this.deploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/examples/group/concurrency/process.jpdl.xml").deploy();
    }

    protected void tearDown() throws Exception {
        this.repositoryService.deleteDeploymentCascade(this.deploymentId);
        super.tearDown();
    }

    public void testOneFeedbackLoop() {
        ProcessInstance pi = this.executionService.startProcessInstanceByKey("GroupConcurrency");
        String documentExecutionId = pi.findActiveExecutionIn("distribute document").getId();
        String planningExecutionId = pi.findActiveExecutionIn("make planning").getId();
        pi = this.executionService.signalExecutionById(documentExecutionId);
        GroupConcurrencyTest.assertNotNull((Object)pi.findActiveExecutionIn("collect feedback"));
        GroupConcurrencyTest.assertNotNull((Object)pi.findActiveExecutionIn("make planning"));
        pi = this.executionService.signalExecutionById(planningExecutionId);
        GroupConcurrencyTest.assertNotNull((Object)pi.findActiveExecutionIn("collect feedback"));
        GroupConcurrencyTest.assertNotNull((Object)pi.findActiveExecutionIn("estimate budget"));
        pi = this.executionService.signalExecutionById(planningExecutionId);
        GroupConcurrencyTest.assertNotNull((Object)pi.findActiveExecutionIn("collect feedback"));
        pi = this.executionService.signalExecutionById(documentExecutionId);
        GroupConcurrencyTest.assertNotNull((Object)pi.findActiveExecutionIn("public project announcement"));
    }
}

