/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test;

import com.mockrunner.ejb.JNDIUtil;
import com.mockrunner.jms.JMSTestModule;
import com.mockrunner.mock.jms.JMSMockObjectFactory;
import com.mockrunner.mock.jms.MockQueue;
import com.mockrunner.mock.jms.MockQueueConnectionFactory;
import com.mockrunner.mock.jms.MockTopic;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XAQueueSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import junit.framework.AssertionFailedError;
import org.jbpm.api.JbpmException;

public abstract class JmsExtensions {
    static Map<String, JMSMockObjectFactory> jmsMockObjectFactories;
    static Map<String, JMSTestModule> jmsTestModules;

    public static void createQueue(String connectionFactoryJndiName, String queueJndiName) {
        MockQueue queue = JmsExtensions.getJmsTestModule(connectionFactoryJndiName).getDestinationManager().createQueue(queueJndiName);
        JmsExtensions.bindToJndi(queueJndiName, queue);
    }

    public static void removeQueue(String connectionFactoryJndiName, String queueJndiName) {
        JmsExtensions.getJmsTestModule(connectionFactoryJndiName).getDestinationManager().removeQueue(queueJndiName);
        JmsExtensions.unbindFromJndi(queueJndiName);
    }

    public static void createTopic(String connectionFactoryJndiName, String topicJndiName) {
        MockTopic topic = JmsExtensions.getJmsTestModule(connectionFactoryJndiName).getDestinationManager().createTopic(topicJndiName);
        JmsExtensions.bindToJndi(topicJndiName, topic);
    }

    public static void removeTopic(String connectionFactoryJndiName, String topicJndiName) {
        JmsExtensions.getJmsTestModule(connectionFactoryJndiName).getDestinationManager().removeTopic(topicJndiName);
        JmsExtensions.unbindFromJndi(topicJndiName);
    }

    protected static void bindToJndi(String jndiName, Object object) {
        try {
            new InitialContext().bind(jndiName, object);
        }
        catch (Exception e) {
            throw new JbpmException("couldn't bind object '" + object + "' to jndi name '" + jndiName + "': " + e.getMessage(), (Throwable)e);
        }
    }

    protected static void unbindFromJndi(String jndiName) {
        try {
            new InitialContext().unbind(jndiName);
        }
        catch (Exception e) {
            throw new JbpmException("couldn't unbind object from jndi name '" + jndiName + "': " + e.getMessage(), (Throwable)e);
        }
    }

    private static JMSTestModule getJmsTestModule(String connectionFactoryJndiName) {
        JMSTestModule jmsTestModule = jmsTestModules.get(connectionFactoryJndiName);
        if (jmsTestModule == null) {
            JMSMockObjectFactory jmsMockObjectFactory = JmsExtensions.getMockObjectFactory(connectionFactoryJndiName);
            jmsTestModule = new JMSTestModule(jmsMockObjectFactory);
            jmsTestModules.put(connectionFactoryJndiName, jmsTestModule);
        }
        return jmsTestModule;
    }

    private static JMSMockObjectFactory getMockObjectFactory(String connectionFactoryJndiName) {
        JMSMockObjectFactory jmsMockObjectFactory = jmsMockObjectFactories.get(connectionFactoryJndiName);
        if (jmsMockObjectFactory == null) {
            jmsMockObjectFactory = new JMSMockObjectFactory();
            jmsMockObjectFactories.put(connectionFactoryJndiName, jmsMockObjectFactory);
            MockQueueConnectionFactory mockQueueConnectionFactory = jmsMockObjectFactory.getMockQueueConnectionFactory();
            try {
                new InitialContext().bind(connectionFactoryJndiName, (Object)mockQueueConnectionFactory);
            }
            catch (Exception e) {
                throw new JbpmException("couldn't bind mock queue connection factory  '" + connectionFactoryJndiName + "': " + e.getMessage(), (Throwable)e);
            }
        }
        return jmsMockObjectFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object consumeMessageFromQueueXA(String connectionFactoryJndiName, String queueJndiName, long timeout) {
        Message message;
        InitialContext context = new InitialContext();
        Queue queue = (Queue)context.lookup(queueJndiName);
        XAQueueConnectionFactory xaQueueConnectionFactory = (XAQueueConnectionFactory)context.lookup(connectionFactoryJndiName);
        XAQueueConnection xaQueueConnection = null;
        XAQueueSession queueSession = null;
        MessageConsumer messageConsumer = null;
        try {
            xaQueueConnection = xaQueueConnectionFactory.createXAQueueConnection();
            xaQueueConnection.start();
            queueSession = xaQueueConnection.createXAQueueSession();
            messageConsumer = queueSession.createConsumer((Destination)queue);
            Message message2 = messageConsumer.receive(timeout);
            if (message2 == null) {
                throw new AssertionFailedError("no message on queue " + queueJndiName);
            }
            message = message2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    messageConsumer.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    queueSession.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    xaQueueConnection.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JbpmException("couldn't receive message from queue: " + e.getMessage(), (Throwable)e);
            }
        }
        try {
            messageConsumer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            queueSession.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            xaQueueConnection.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Message consumeMessageFromQueue(String connectionFactoryJndiName, String queueJndiName, long timeout, boolean transacted, int acknowledgeMode) {
        Message message;
        InitialContext context = new InitialContext();
        QueueConnectionFactory queueConnectionFactory = (QueueConnectionFactory)context.lookup(connectionFactoryJndiName);
        Queue queue = (Queue)context.lookup(queueJndiName);
        QueueConnection queueConnection = null;
        QueueSession queueSession = null;
        MessageConsumer messageConsumer = null;
        try {
            queueConnection = queueConnectionFactory.createQueueConnection();
            queueConnection.start();
            queueSession = queueConnection.createQueueSession(transacted, acknowledgeMode);
            messageConsumer = queueSession.createConsumer((Destination)queue);
            Message message2 = messageConsumer.receive(timeout);
            if (message2 == null) {
                throw new AssertionFailedError("no message on queue " + queueJndiName);
            }
            if (transacted) {
                queueSession.commit();
            }
            message = message2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    messageConsumer.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    queueSession.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    queueConnection.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JbpmException("couldn't receive message from queue: " + e.getMessage(), (Throwable)e);
            }
        }
        try {
            messageConsumer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            queueSession.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            queueConnection.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message;
    }

    public static void jmsAssertQueueEmptyXA(String connectionFactoryJndiName, String queueJndiName, long timeout) {
        block2: {
            try {
                JmsExtensions.consumeMessageFromQueueXA(connectionFactoryJndiName, queueJndiName, timeout);
            }
            catch (AssertionFailedError e) {
                if (!e.getMessage().startsWith("no message on queue")) break block2;
                return;
            }
        }
        throw new AssertionFailedError("message available on queue " + queueJndiName);
    }

    public static void jmsAssertQueueEmpty(String connectionFactoryJndiName, String queueJndiName, long timeout, boolean transacted, int acknowledgeMode) {
        block2: {
            try {
                JmsExtensions.consumeMessageFromQueue(connectionFactoryJndiName, queueJndiName, timeout, transacted, acknowledgeMode);
            }
            catch (AssertionFailedError e) {
                if (!e.getMessage().startsWith("no message on queue")) break block2;
                return;
            }
        }
        throw new AssertionFailedError("message available on queue " + queueJndiName);
    }

    static {
        try {
            new InitialContext().getEnvironment();
        }
        catch (NamingException e) {
            try {
                JNDIUtil.initMockContextFactory();
            }
            catch (Exception e2) {
                e.printStackTrace();
                throw new RuntimeException("coudn't initialize mock jndi: " + e2.getMessage(), e2);
            }
        }
        jmsMockObjectFactories = new HashMap<String, JMSMockObjectFactory>();
        jmsTestModules = new HashMap<String, JMSTestModule>();
    }
}

