/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
/**
 * 
 */
package org.jbpm.test.assertion;

import java.util.Collection;
import java.util.Iterator;

import junit.framework.Assert;

/**
 * Utility class with assertions for collections.
 * 
 * @author Joram Barrez
 */
public class CollectionAssertions {
  
  public static <T>  void assertElementsEqual(Collection<T> collection1, Collection<T> collection2) {
    
    Assert.assertTrue( (collection1 == null && collection2 == null) 
                    || (collection1 != null && collection2 != null) );
    
    if (collection1 != null && collection2 != null) {
      
      Assert.assertEquals(collection1.size(), collection2.size());
      
      Iterator<T> it1 = collection1.iterator();
      Iterator<T> it2 = collection2.iterator();
      
      while (it1.hasNext()) {
        T t1 = it1.next();
        T t2 = it2.next();
        Assert.assertEquals(t1, t2);
      }
      
    }
    
  }

}
