/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test;

import java.lang.reflect.Field;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.jbpm.session.DbSession;
import org.jbpm.test.Db;
import org.jbpm.test.EnvironmentTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentDbTestCase
extends EnvironmentTestCase {
    Transaction transaction = null;

    public EnvironmentDbTestCase() {
    }

    public EnvironmentDbTestCase(String configResource) {
        super(configResource);
    }

    @Override
    public void setUp() throws Exception {
        if (this.isEnvironmentFactoryCached()) {
            Db.clean(this.getEnvironmentFactory());
        }
        super.setUp();
        this.beginTransaction();
    }

    @Override
    public void tearDown() throws Exception {
        this.commitTransaction();
        super.tearDown();
    }

    void beginTransaction() {
        Session session = (Session)this.environment.get(Session.class);
        this.transaction = session.beginTransaction();
    }

    void commitTransaction() {
        this.transaction.commit();
        this.transaction = null;
    }

    void rollbackTransaction() {
        this.transaction.rollback();
        this.transaction = null;
    }

    public DbSession getDbSession() {
        return (DbSession)this.environment.get(DbSession.class);
    }

    public void rollbackAndBeginNewTransaction() {
        this.rollbackTransaction();
        this.closeEnvironment();
        this.openEnvironment();
        this.beginTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newTransaction() {
        try {
            this.commitTransaction();
            this.closeEnvironment();
        }
        finally {
            this.openEnvironment();
            this.beginTransaction();
        }
    }

    public void beginCacheTest() {
        SessionFactory sessionFactory = (SessionFactory)this.environment.get(SessionFactory.class);
        if (sessionFactory != null) {
            log.debug("=================================================================");
            log.debug("Beginning of the cache test, no more sql query should be performed before the end of the test");
            log.debug("=================================================================");
            sessionFactory.getStatistics().clear();
            sessionFactory.getStatistics().setStatisticsEnabled(true);
        }
    }

    public void endCacheTest() {
        SessionFactory sessionFactory = (SessionFactory)this.environment.get(SessionFactory.class);
        if (sessionFactory != null) {
            EnvironmentDbTestCase.assertEquals((long)0L, (long)sessionFactory.getStatistics().getEntityLoadCount());
            EnvironmentDbTestCase.assertEquals((long)0L, (long)sessionFactory.getStatistics().getCollectionLoadCount());
        }
    }

    public <T> T reload(Object object, Class<T> persistentClass) {
        ((DbSession)this.environment.get(DbSession.class)).save(object);
        this.newTransaction();
        Long dbid = null;
        try {
            Field dbidField = this.getDbidField(persistentClass);
            dbidField.setAccessible(true);
            dbid = (Long)dbidField.get(object);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (T)((DbSession)this.environment.get(DbSession.class)).get(persistentClass, (Object)dbid);
    }

    private Field getDbidField(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!"dbid".equals(fields[i].getName())) continue;
            return fields[i];
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            return this.getDbidField(superClass);
        }
        throw new RuntimeException("no dbid field in object to reload");
    }
}

