/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.internal.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jbpm.pvm.internal.util.EqualsUtil;
import org.jbpm.task.Role;
import org.jbpm.task.Swimlane;
import org.jbpm.task.SwimlaneDefinition;
import org.jbpm.task.TaskException;
import org.jbpm.task.internal.model.RoleImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwimlaneImpl
implements Serializable,
Swimlane {
    private static final long serialVersionUID = 1L;
    protected long dbid;
    protected int dbversion;
    protected String name = null;
    protected String assignee = null;
    protected Set<RoleImpl> candidates = null;
    protected SwimlaneDefinition swimlaneDefinition = null;

    @Override
    public String getAssignee() {
        return this.assignee;
    }

    @Override
    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    @Override
    public Collection<Role> getCandidates() {
        if (this.candidates == null) {
            return Collections.EMPTY_LIST;
        }
        return this.candidates;
    }

    @Override
    public Role createCandidate(String identityId) {
        if (identityId == null) {
            throw new TaskException("identityId is null");
        }
        RoleImpl role = new RoleImpl();
        role.setIdentityId(identityId);
        role.setRoleType("candidate");
        role.setSwimlane(this);
        if (this.candidates == null) {
            this.candidates = new HashSet<RoleImpl>();
        }
        this.candidates.add(role);
        return role;
    }

    @Override
    public void removeCandidate(Role candidate) {
        if (candidate == null) {
            throw new TaskException("candidate is null");
        }
        if (this.candidates != null && this.candidates.remove(candidate)) {
            ((RoleImpl)candidate).setTask(null);
        }
    }

    public boolean equals(Object o) {
        return EqualsUtil.equals((Object)this, (Object)o);
    }

    @Override
    public long getDbid() {
        return this.dbid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public SwimlaneDefinition getSwimlaneDefinition() {
        return this.swimlaneDefinition;
    }

    public void setSwimlaneDefinition(SwimlaneDefinition swimlaneDefinition) {
        this.swimlaneDefinition = swimlaneDefinition;
    }

    public void setName(String name) {
        this.name = name;
    }
}

