/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.internal.model;

import java.util.HashMap;
import java.util.Map;
import org.jbpm.client.ClientProcessInstance;
import org.jbpm.model.IdGenerator;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.NodeImpl;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;
import org.jbpm.task.TaskException;
import org.jbpm.task.internal.model.LifeCycleParser;
import org.jbpm.task.internal.model.TaskImpl;

public class LifeCycle
extends ProcessDefinitionImpl {
    private static final long serialVersionUID = 1L;
    private static LifeCycleParser lifeCycleParser = new LifeCycleParser();
    private static Map<String, ProcessDefinitionImpl> lifeCycleProcesses = new HashMap<String, ProcessDefinitionImpl>();

    public static String initialise(TaskImpl task) {
        ProcessDefinitionImpl lifeCycle = LifeCycle.getLifeCycle(task);
        HashMap<String, TaskImpl> lifeCycleVariables = new HashMap<String, TaskImpl>();
        lifeCycleVariables.put("task", task);
        ClientProcessInstance lifeCycleExecution = lifeCycle.createProcessInstance();
        lifeCycleExecution.setVariables(lifeCycleVariables);
        lifeCycleExecution.start();
        return lifeCycleExecution.getNode().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessDefinitionImpl getLifeCycle(TaskImpl task) {
        ProcessDefinitionImpl lifeCycleProcess;
        if (task == null) {
            throw new TaskException("task is null");
        }
        String resource = task.getLifeCycleResource();
        if (resource == null) {
            throw new TaskException("task " + task.getClass().getName() + " did'nt return a lifecycle");
        }
        Map<String, ProcessDefinitionImpl> map = lifeCycleProcesses;
        synchronized (map) {
            lifeCycleProcess = lifeCycleProcesses.get(resource);
            if (lifeCycleProcess == null) {
                lifeCycleProcess = (ProcessDefinitionImpl)lifeCycleParser.createParse().setResource(resource).execute().checkProblems("task lifecycle").getDocumentObject();
                lifeCycleProcesses.put(resource, lifeCycleProcess);
            }
        }
        return lifeCycleProcess;
    }

    protected static void fireLifeCycleEvent(String eventName, TaskImpl task) {
        ExecutionImpl lifeCycleExecution = new ExecutionImpl();
        ProcessDefinitionImpl lifeCycleProcess = LifeCycle.getLifeCycle(task);
        lifeCycleExecution.setProcessDefinition(lifeCycleProcess);
        String state = task.getState();
        NodeImpl node = lifeCycleProcess.getNode(state);
        lifeCycleExecution.setNode(node);
        lifeCycleExecution.signal(eventName);
        task.state = lifeCycleExecution.getNode().getName();
    }

    public IdGenerator getIdGenerator() {
        return null;
    }
}

