/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.internal.model;

import java.util.List;
import org.jbpm.TaskService;
import org.jbpm.cmd.Command;
import org.jbpm.cmd.CommandService;
import org.jbpm.task.Role;
import org.jbpm.task.Task;
import org.jbpm.task.internal.cmd.DeleteTaskCmd;
import org.jbpm.task.internal.cmd.GetPersonalTaskListCmd;
import org.jbpm.task.internal.cmd.GetTaskCmd;
import org.jbpm.task.internal.cmd.NewTaskCmd;
import org.jbpm.task.internal.cmd.SaveTaskCmd;
import org.jbpm.task.internal.cmd.SubmitTaskCmd;
import org.jbpm.task.internal.model.TaskImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskServiceImpl
implements TaskService {
    protected CommandService commandService;

    public TaskServiceImpl() {
    }

    public TaskServiceImpl(CommandService commandService) {
        this.commandService = commandService;
    }

    public CommandService getCommandService() {
        return this.commandService;
    }

    public void setCommandService(CommandService commandService) {
        this.commandService = commandService;
    }

    public Task newTask() {
        return (Task)this.commandService.execute((Command)new NewTaskCmd());
    }

    public Task getTask(String taskId) {
        return (Task)this.commandService.execute((Command)new GetTaskCmd(taskId));
    }

    public void saveTask(Task task) {
        this.commandService.execute((Command)new SaveTaskCmd((TaskImpl)task));
    }

    public void deleteTask(String taskId) {
        this.commandService.execute((Command)new DeleteTaskCmd(taskId));
    }

    public void submitTask(String taskId) {
        this.commandService.execute((Command)new SubmitTaskCmd(taskId));
    }

    public void submitTask(Task task) {
        this.commandService.execute((Command)new SubmitTaskCmd((TaskImpl)task));
    }

    public List<String> getCandidates(String taskId) {
        return null;
    }

    public List<Role> getRoles(String taskId) {
        return null;
    }

    public List<Task> getPersonalTaskList(String userId, int firstResult, int maxResults) {
        return (List)this.commandService.execute((Command)new GetPersonalTaskListCmd(userId, firstResult, maxResults));
    }

    public List<Task> getGroupTaskList(String userId, int firstResult, int maxResults) {
        return null;
    }
}

