/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.internal.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jbpm.Execution;
import org.jbpm.model.Comment;
import org.jbpm.pvm.internal.cal.Duration;
import org.jbpm.pvm.internal.model.CommentImpl;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.ScopeInstanceImpl;
import org.jbpm.pvm.internal.util.Clock;
import org.jbpm.pvm.internal.util.EqualsUtil;
import org.jbpm.task.Role;
import org.jbpm.task.Swimlane;
import org.jbpm.task.Task;
import org.jbpm.task.TaskDefinition;
import org.jbpm.task.TaskException;
import org.jbpm.task.internal.model.LifeCycle;
import org.jbpm.task.internal.model.RoleImpl;
import org.jbpm.task.internal.model.SwimlaneImpl;
import org.jbpm.task.internal.model.TaskDefinitionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskImpl
extends ScopeInstanceImpl
implements Serializable,
Task {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String name;
    protected String description;
    protected String assignee;
    protected Set<RoleImpl> roles;
    protected Date create;
    protected Date dueDate;
    protected Integer progress;
    protected List<CommentImpl> comments;
    protected int priority = 0;
    protected String state;
    protected ExecutionImpl execution;
    protected boolean isSignalling = true;
    protected boolean isBlocking;
    protected TaskDefinitionImpl taskDefinition;
    protected SwimlaneImpl swimlane;
    protected TaskImpl superTask;
    protected Set<TaskImpl> subTasks;

    protected TaskImpl() {
    }

    public static TaskImpl create() {
        return TaskImpl.create(null);
    }

    public static TaskImpl create(Execution execution) {
        TaskImpl task = new TaskImpl();
        task.setCreate(Clock.getCurrentTime());
        task.setExecution(execution);
        task.state = LifeCycle.initialise(task);
        return task;
    }

    public void setTaskDefinition(TaskDefinitionImpl taskDefinition) {
        this.taskDefinition = taskDefinition;
        if (taskDefinition != null) {
            this.name = taskDefinition.getName();
            this.description = taskDefinition.getDescription();
            this.isBlocking = taskDefinition.isBlocking();
            this.isSignalling = taskDefinition.isSignalling();
            this.priority = taskDefinition.getPriority();
            String durationText = taskDefinition.getDueDateDuration();
            if (durationText != null) {
                this.dueDate = TaskImpl.calculateDueDate(new Duration(durationText));
            }
        }
    }

    protected static Date calculateDueDate(Duration dueDate) {
        return null;
    }

    public Set<RoleImpl> getRoles() {
        if (this.roles == null) {
            return Collections.emptySet();
        }
        return this.roles;
    }

    public Set<RoleImpl> getAllRoles() {
        HashSet<RoleImpl> allRoles = null;
        allRoles = this.roles != null ? new HashSet<RoleImpl>(this.roles) : new HashSet();
        if (this.swimlane != null) {
            allRoles.addAll((Set)this.swimlane.getCandidates());
        }
        return allRoles;
    }

    public Role addRole(String identityId, String roleType) {
        if (identityId == null) {
            throw new TaskException("userId is null");
        }
        if (roleType == null) {
            throw new TaskException("roleType is null");
        }
        RoleImpl role = new RoleImpl();
        role.setIdentityId(identityId);
        role.setTask(this);
        role.setRoleType(roleType);
        if (this.roles == null) {
            this.roles = new HashSet<RoleImpl>();
        }
        this.roles.add(role);
        return role;
    }

    public void removeRole(Role role) {
        if (role == null) {
            throw new TaskException("role is null");
        }
        if (this.roles != null && this.roles.remove(role)) {
            ((RoleImpl)role).setTask(null);
        }
    }

    public void submit() {
        if (this.execution != null) {
            String outcome = this.evaluateOutcome();
            this.execution.signal(outcome);
        }
    }

    public String evaluateOutcome() {
        return null;
    }

    public List<Comment> getComments() {
        if (this.comments == null) {
            return Collections.emptyList();
        }
        return this.comments;
    }

    public Comment createComment(String commentText) {
        if (this.comments == null) {
            this.comments = new ArrayList<CommentImpl>();
        }
        CommentImpl comment = new CommentImpl(commentText);
        this.comments.add(comment);
        return comment;
    }

    public void removeComment(Comment comment) {
        if (comment == null) {
            throw new TaskException("comment is null");
        }
        if (this.comments != null) {
            this.comments.remove(comment);
        }
    }

    public Set<Task> getSubTasks() {
        if (this.subTasks == null) {
            return Collections.emptySet();
        }
        return this.subTasks;
    }

    public Task createSubTask(String name) {
        if (this.subTasks == null) {
            this.subTasks = new HashSet<TaskImpl>();
        }
        TaskImpl subtask = new TaskImpl();
        subtask.setName(name);
        this.addSubTask(subtask);
        return subtask;
    }

    public Task addSubTask(TaskImpl subtask) {
        if (this.subTasks == null) {
            this.subTasks = new HashSet<TaskImpl>();
        }
        subtask.setSuperTask(this);
        this.subTasks.add(subtask);
        return subtask;
    }

    public void removeSubTask(Task subtask) {
        if (subtask == null) {
            throw new TaskException("subtask is null");
        }
        if (this.subTasks != null && this.subTasks.remove(subtask)) {
            ((TaskImpl)subtask).setSuperTask(null);
        }
    }

    public boolean equals(Object o) {
        return EqualsUtil.equals((Object)this, (Object)o);
    }

    public String getLifeCycleResource() {
        return "jbpm.task.default.lifecycle.xml";
    }

    public void setProgress(Integer progress) {
        if (progress < 0 || progress > 100) {
            throw new TaskException("task progress is a percentage (integer) and must be expressed between 0 and 100");
        }
        this.progress = progress;
    }

    public boolean isPersisted() {
        return this.dbid != 0L;
    }

    public long getDbid() {
        return this.dbid;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isBlocking() {
        return this.isBlocking;
    }

    public void setBlocking(boolean isBlocking) {
        this.isBlocking = isBlocking;
    }

    public boolean isSignalling() {
        return this.isSignalling;
    }

    public void setSignalling(boolean isSignalling) {
        this.isSignalling = isSignalling;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setComments(List<CommentImpl> comments) {
        this.comments = comments;
    }

    public Date getCreate() {
        return this.create;
    }

    public void setCreate(Date create) {
        this.create = create;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public ExecutionImpl getExecution() {
        return this.execution;
    }

    public void setExecution(Execution execution) {
        this.execution = (ExecutionImpl)execution;
    }

    public String getState() {
        return this.state;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignedUserId) {
        this.assignee = assignedUserId;
    }

    public Swimlane getSwimlane() {
        return this.swimlane;
    }

    public void setSwimlane(SwimlaneImpl swimlane) {
        this.swimlane = swimlane;
    }

    public TaskDefinition getTaskDefinition() {
        return this.taskDefinition;
    }

    public TaskImpl getSuperTask() {
        return this.superTask;
    }

    public void setSuperTask(TaskImpl superTask) {
        this.superTask = superTask;
    }

    public Integer getProgress() {
        return this.progress;
    }
}

