/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.internal.model;

import java.util.List;
import org.jbpm.activity.Activity;
import org.jbpm.pvm.internal.model.NodeImpl;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.xml.Parse;
import org.jbpm.pvm.internal.xml.Parser;
import org.jbpm.task.internal.model.LifeCycle;
import org.jbpm.task.internal.model.LifeCycleState;
import org.w3c.dom.Element;

public class LifeCycleParser
extends Parser {
    public Object parseDocumentElement(Element element, Parse parse) {
        LifeCycle lifeCycleProcess = new LifeCycle();
        List stateElements = XmlUtil.elements((Element)element, (String)"state");
        for (Element stateElement : stateElements) {
            this.parseState(stateElement, lifeCycleProcess, parse);
        }
        for (Element stateElement : stateElements) {
            this.parseTransitions(stateElement, lifeCycleProcess, parse);
        }
        String initialStateName = null;
        if (element.hasAttribute("initial")) {
            initialStateName = element.getAttribute("initial");
            NodeImpl initial = lifeCycleProcess.getNode(initialStateName);
            if (initial != null) {
                lifeCycleProcess.setInitial(initial);
            } else {
                parse.addProblem("initial " + initialStateName + " doesn't exist");
            }
        }
        return lifeCycleProcess;
    }

    public void parseTransitions(Element element, ProcessDefinitionImpl lifeCycleProcess, Parse parse) {
        if (!element.hasAttribute("name")) {
            parse.addProblem("state doesn't have a name: " + XmlUtil.toString((Element)element));
            return;
        }
        String stateName = element.getAttribute("name");
        NodeImpl state = lifeCycleProcess.getNode(stateName);
        List transitionElements = XmlUtil.elements((Element)element, (String)"transition");
        for (Element transitionElement : transitionElements) {
            this.parseTransition(transitionElement, state, parse);
        }
    }

    public void parseTransition(Element element, NodeImpl state, Parse parse) {
        if (!element.hasAttribute("name")) {
            parse.addProblem("transition doesn't have a name: " + XmlUtil.toString((Element)element));
            return;
        }
        String transitionName = element.getAttribute("name");
        if (!element.hasAttribute("to")) {
            parse.addProblem("transition " + transitionName + " doesn't have a to attribute indicating the destination state: " + XmlUtil.toString((Element)element));
            return;
        }
        String destinationName = element.getAttribute("to");
        NodeImpl destination = (NodeImpl)state.getProcessDefinition().getNode(destinationName);
        if (destination != null) {
            state.createOutgoingTransition(destination, transitionName);
        } else {
            parse.addProblem("destination " + destinationName + " of " + transitionName + " is unknown");
        }
    }

    public void parseState(Element element, ProcessDefinitionImpl lifeCycleProcess, Parse parse) {
        if (!element.hasAttribute("name")) {
            parse.addProblem("state doesn't have an id: " + XmlUtil.toString((Element)element));
            return;
        }
        String stateName = element.getAttribute("name");
        NodeImpl state = lifeCycleProcess.createNode(stateName);
        state.setBehaviour((Activity)new LifeCycleState());
    }
}

