/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.internal.hibernate;

import java.io.Serializable;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.jbpm.pvm.internal.hibernate.HibernateDbSession;
import org.jbpm.task.Task;
import org.jbpm.task.internal.model.TaskImpl;
import org.jbpm.task.session.TaskDbSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateTaskDbSession
extends HibernateDbSession
implements TaskDbSession {
    @Override
    public TaskImpl findTaskById(String taskId) {
        return (TaskImpl)this.session.createCriteria(TaskImpl.class).add((Criterion)Restrictions.eq((String)"id", (Object)taskId)).uniqueResult();
    }

    @Override
    public List<Task> findPersonalTasks(String userId, int firstResult, int maxResults) {
        return this.session.createCriteria(TaskImpl.class).add((Criterion)Restrictions.eq((String)"assignee", (Object)userId)).setFirstResult(firstResult).setMaxResults(maxResults).list();
    }

    @Override
    public void saveTask(TaskImpl task) {
        if (!task.isPersisted()) {
            Serializable dbid = this.session.save((Object)task);
            if (task.getId() == null) {
                task.setId(dbid.toString());
            }
        } else {
            this.session.update((Object)task);
        }
    }
}

