/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.wire.xml;

import java.util.List;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.util.ReflectUtil;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.xml.Binding;
import org.jbpm.pvm.internal.xml.Bindings;
import org.jbpm.pvm.internal.xml.Parse;
import org.jbpm.pvm.internal.xml.Parser;
import org.w3c.dom.Element;

public class BindingParser
extends Parser {
    private static final Log log = Log.getLog((String)BindingParser.class.getName());

    public Object parseDocumentElement(Element documentElement, Parse parse) {
        List<Element> elements = XmlUtil.elements(documentElement, "binding");
        for (Element bindingElement : elements) {
            String bindingClassName = XmlUtil.attribute(bindingElement, "class");
            log.trace("adding wire binding for " + bindingClassName);
            Binding binding = null;
            if (bindingClassName != null) {
                try {
                    Class<?> bindingClass = ReflectUtil.classForName(bindingClassName);
                    binding = (Binding)bindingClass.newInstance();
                }
                catch (Exception e) {
                    log.trace("couldn't instantiate binding " + bindingClassName);
                }
            } else {
                parse.addProblem("class is a required attribute in a binding " + XmlUtil.toString(bindingElement), documentElement);
            }
            if (binding == null) continue;
            Bindings bindings = parse.contextStackFind(Bindings.class);
            bindings.addBinding(binding);
        }
        return null;
    }
}

