/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.wire.descriptor;

import org.jbpm.api.JbpmException;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.jobexecutor.JobExecutor;
import org.jbpm.pvm.internal.util.Listener;
import org.jbpm.pvm.internal.wire.WireContext;
import org.jbpm.pvm.internal.wire.descriptor.ObjectDescriptor;

public class JobExecutorDescriptor
extends ObjectDescriptor {
    private static final long serialVersionUID = 1L;
    private static final Log log = Log.getLog((String)JobExecutorDescriptor.class.getName());
    private boolean autoStart = false;

    public JobExecutorDescriptor() {
        super(JobExecutor.class.getName());
    }

    public Object construct(WireContext wireContext) {
        JobExecutor jobExecutor = (JobExecutor)super.construct(wireContext);
        if (this.autoStart) {
            wireContext.addListener(new JobExecutorStopper(jobExecutor));
        }
        return jobExecutor;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public static class JobExecutorStopper
    implements Listener {
        JobExecutor jobExecutor;

        public JobExecutorStopper(JobExecutor jobExecutor) {
            this.jobExecutor = jobExecutor;
        }

        public void event(Object source, String eventName, Object info) {
            if ("close".equals(eventName)) {
                log.trace("stopping jobExecutor");
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    throw new JbpmException("exception while stopping JobExecutor");
                }
                this.jobExecutor.stop(true);
            }
        }
    }
}

