/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.wire.descriptor;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.hibernate.cfg.Configuration;
import org.jbpm.api.JbpmException;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.util.ReflectUtil;
import org.jbpm.pvm.internal.wire.WireContext;
import org.jbpm.pvm.internal.wire.WireDefinition;
import org.jbpm.pvm.internal.wire.WireException;
import org.jbpm.pvm.internal.wire.descriptor.AbstractDescriptor;
import org.jbpm.pvm.internal.wire.descriptor.PropertiesDescriptor;
import org.jbpm.pvm.internal.wire.operation.Operation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateConfigurationDescriptor
extends AbstractDescriptor {
    private static final long serialVersionUID = 1L;
    private static final Log log = Log.getLog((String)HibernateConfigurationDescriptor.class.getName());
    String className;
    String namingStrategyClassName;
    List<Operation> cfgOperations = new ArrayList<Operation>();
    List<Operation> cfgCacheOperations = new ArrayList<Operation>();
    PropertiesDescriptor propertiesDescriptor = null;

    @Override
    public Object construct(WireContext wireContext) {
        Configuration configuration = null;
        if (this.className != null) {
            try {
                log.trace("instantiating hibernate configuration class " + this.className);
                Class<?> configurationClass = ReflectUtil.classForName(this.className);
                configuration = (Configuration)ReflectUtil.newInstance(configurationClass);
            }
            catch (Exception e) {
                throw new JbpmException("couldn't instantiate hibernate configuration class " + this.className, (Throwable)e);
            }
        } else {
            log.trace("instantiating default hibernate configuration");
            configuration = new Configuration();
        }
        return configuration;
    }

    @Override
    public void initialize(Object object, WireContext wireContext) {
        Configuration configuration = (Configuration)object;
        this.apply(this.cfgOperations, configuration, wireContext);
        this.apply(this.cfgCacheOperations, configuration, wireContext);
        if (this.propertiesDescriptor != null) {
            Properties properties = (Properties)wireContext.create(this.propertiesDescriptor, false);
            if (log.isDebugEnabled()) {
                log.debug("adding properties to hibernate configuration: " + properties);
            }
            configuration.addProperties(properties);
        }
    }

    private void apply(List<Operation> operations, Configuration configuration, WireContext wireContext) {
        if (operations != null) {
            for (Operation operation : operations) {
                log.trace(operation.toString());
                operation.apply(configuration, wireContext);
            }
        }
    }

    @Override
    public Class<?> getType(WireDefinition wireDefinition) {
        if (this.className != null) {
            try {
                return ReflectUtil.classForName(this.className);
            }
            catch (Exception e) {
                throw new WireException("couldn't create hibernate configuration '" + this.className + "': " + e.getMessage(), e.getCause());
            }
        }
        return Configuration.class;
    }

    public void addCfgResource(String cfgResource) {
        this.cfgOperations.add(new AddCfgResource(cfgResource));
    }

    public void addCfgFile(String cfgFile) {
        this.cfgOperations.add(new AddCfgFile(cfgFile));
    }

    public void addCfgUrl(String cfgUrl) {
        this.cfgOperations.add(new AddCfgUrl(cfgUrl));
    }

    public void addMappingResource(String mappingResource) {
        this.cfgOperations.add(new AddMappingResource(mappingResource));
    }

    public void addMappingFile(String mappingFileName) {
        this.cfgOperations.add(new AddMappingFile(mappingFileName));
    }

    public void addMappingClass(String mappingClassName) {
        this.cfgOperations.add(new AddMappingClass(mappingClassName));
    }

    public void addMappingUrl(String mappingUrl) {
        this.cfgOperations.add(new AddMappingUrl(mappingUrl));
    }

    public void addClassToCache(String className, String concurrencyStrategy) {
        this.cfgCacheOperations.add(new SetCacheConcurrencyStrategy(className, concurrencyStrategy));
    }

    public void addCollectionToCache(String collectionName, String concurrencyStrategy) {
        this.cfgCacheOperations.add(new SetCollectionCacheConcurrencyStrategy(collectionName, concurrencyStrategy));
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public PropertiesDescriptor getPropertiesDescriptor() {
        return this.propertiesDescriptor;
    }

    public void setPropertiesDescriptor(PropertiesDescriptor propertiesDescriptor) {
        this.propertiesDescriptor = propertiesDescriptor;
    }

    public String getNamingStrategyClassName() {
        return this.namingStrategyClassName;
    }

    public void setNamingStrategyClassName(String namingStrategyClassName) {
        this.namingStrategyClassName = namingStrategyClassName;
    }

    public static class SetCollectionCacheConcurrencyStrategy
    implements Operation {
        private static final long serialVersionUID = 1L;
        String collection;
        String concurrencyStrategy;

        public SetCollectionCacheConcurrencyStrategy(String collection, String concurrencyStrategy) {
            this.collection = collection;
            this.concurrencyStrategy = concurrencyStrategy;
        }

        public void apply(Object target, WireContext wireContext) {
            Configuration configuration = (Configuration)target;
            configuration.setCollectionCacheConcurrencyStrategy(this.collection, this.concurrencyStrategy);
        }

        public String toString() {
            return "setting cache concurrency strategy on collection " + this.collection + " to " + this.concurrencyStrategy + " on hibernate configuration";
        }
    }

    public static class SetCacheConcurrencyStrategy
    implements Operation {
        private static final long serialVersionUID = 1L;
        String className;
        String concurrencyStrategy;

        public SetCacheConcurrencyStrategy(String className, String concurrencyStrategy) {
            this.className = className;
            this.concurrencyStrategy = concurrencyStrategy;
        }

        public void apply(Object target, WireContext wireContext) {
            Configuration configuration = (Configuration)target;
            configuration.setCacheConcurrencyStrategy(this.className, this.concurrencyStrategy);
        }

        public String toString() {
            return "setting cache concurrency strategy on class " + this.className + " to " + this.concurrencyStrategy + " on hibernate configuration";
        }
    }

    public static class AddMappingUrl
    implements Operation {
        private static final long serialVersionUID = 1L;
        String url;

        public AddMappingUrl(String url) {
            this.url = url;
        }

        public void apply(Object target, WireContext wireContext) {
            Configuration configuration = (Configuration)target;
            try {
                configuration.addURL(new URL(this.url));
            }
            catch (Exception e) {
                throw new JbpmException("couldn't add hibernate mapping from URL " + this.url, (Throwable)e);
            }
        }
    }

    public static class AddMappingClass
    implements Operation {
        private static final long serialVersionUID = 1L;
        String className;

        public AddMappingClass(String className) {
            this.className = className;
        }

        public void apply(Object target, WireContext wireContext) {
            Configuration configuration = (Configuration)target;
            try {
                Class<?> persistentClass = ReflectUtil.classForName(this.className);
                configuration.addClass(persistentClass);
            }
            catch (Exception e) {
                throw new JbpmException("couldn't add mapping for class " + this.className, (Throwable)e);
            }
        }

        public String toString() {
            return "adding persistent class " + this.className + " to hibernate configuration";
        }
    }

    public static class AddMappingFile
    implements Operation {
        private static final long serialVersionUID = 1L;
        String fileName;

        public AddMappingFile(String fileName) {
            this.fileName = fileName;
        }

        public void apply(Object target, WireContext wireContext) {
            Configuration configuration = (Configuration)target;
            configuration.addFile(this.fileName);
        }

        public String toString() {
            return "adding hibernate mapping file " + this.fileName + " to configuration";
        }
    }

    public static class AddMappingResource
    implements Operation {
        private static final long serialVersionUID = 1L;
        String resource;

        public AddMappingResource(String resource) {
            this.resource = resource;
        }

        public void apply(Object target, WireContext wireContext) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Configuration configuration = (Configuration)target;
            configuration.addResource(this.resource, classLoader);
        }

        public String toString() {
            return "adding mapping resource " + this.resource + " to hibernate configuration";
        }
    }

    public static class AddCfgUrl
    implements Operation {
        private static final long serialVersionUID = 1L;
        String cfgUrl;

        public AddCfgUrl(String cfgUrl) {
            this.cfgUrl = cfgUrl;
        }

        public void apply(Object target, WireContext wireContext) {
            Configuration configuration = (Configuration)target;
            try {
                URL url = new URL(this.cfgUrl);
                configuration.configure(url);
            }
            catch (Exception e) {
                throw new JbpmException("couldn't configure hibernate with url " + this.cfgUrl, (Throwable)e);
            }
        }

        public String toString() {
            return "adding hibernate cfg url " + this.cfgUrl;
        }
    }

    public static class AddCfgFile
    implements Operation {
        private static final long serialVersionUID = 1L;
        String cfgFileName;

        public AddCfgFile(String cfgFileName) {
            this.cfgFileName = cfgFileName;
        }

        public void apply(Object target, WireContext wireContext) {
            Configuration configuration = (Configuration)target;
            File file = new File(this.cfgFileName);
            configuration.configure(file);
        }

        public String toString() {
            return "adding hibernate cfg file " + this.cfgFileName;
        }
    }

    public static class AddCfgResource
    implements Operation {
        private static final long serialVersionUID = 1L;
        String cfgResource;

        public AddCfgResource(String cfgResource) {
            this.cfgResource = cfgResource;
        }

        public void apply(Object target, WireContext wireContext) {
            Configuration configuration = (Configuration)target;
            configuration.configure(this.cfgResource);
        }

        public String toString() {
            return "adding hibernate cfg resource " + this.cfgResource;
        }
    }
}

