/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.id;

import java.util.Random;
import org.hibernate.StaleStateException;
import org.jbpm.api.JbpmException;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.cmd.CommandService;
import org.jbpm.pvm.internal.id.AcquireDbidBlockCmd;
import org.jbpm.pvm.internal.id.DbidGenerator;
import org.jbpm.pvm.internal.id.InitializePropertiesCmd;

public class DatabaseDbidGenerator
extends DbidGenerator {
    private static Log log = Log.getLog((String)DatabaseDbidGenerator.class.getName());
    static Random random = new Random();
    CommandService commandService;
    long blocksize = 10000L;
    int maxAttempts = 3;
    long lastId = -2L;
    long nextId = -1L;

    public synchronized long getNextId() {
        if (this.lastId < this.nextId) {
            log.debug("last id " + this.lastId + " was consumed.  acquiring new block...");
            this.lastId = -2L;
            this.nextId = -1L;
            try {
                this.acquireDbidBlock();
            }
            catch (Exception e) {
                throw new JbpmException("couldn't acquire block of ids", (Throwable)e);
            }
        }
        return this.nextId++;
    }

    protected void acquireDbidBlock() {
        for (int attempts = this.maxAttempts; attempts > 0 && this.nextId == -1L; --attempts) {
            try {
                this.nextId = this.commandService.execute(new AcquireDbidBlockCmd(this.blocksize));
                this.lastId = this.nextId + this.blocksize - 1L;
                log.debug("acquired new id block [" + this.nextId + "-" + this.lastId + "]");
                continue;
            }
            catch (StaleStateException e) {
                if (--attempts == 0) {
                    throw new JbpmException("couldn't acquire block of ids, tried " + this.maxAttempts + " times");
                }
                int millis = 20 + random.nextInt(200);
                log.debug("optimistic locking failure while trying to acquire id block.  retrying in " + millis + " millis");
                try {
                    Thread.sleep(millis);
                    continue;
                }
                catch (InterruptedException e1) {
                    log.debug("waiting after id block locking failure got interrupted");
                }
            }
        }
    }

    public void reset() {
        this.initialize();
    }

    public void initialize() {
        this.nextId = this.commandService.execute(new InitializePropertiesCmd(this.blocksize));
        this.lastId = this.nextId + this.blocksize - 1L;
        log.debug("initial id block [" + this.nextId + "-" + this.lastId + "]");
    }
}

