/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.cmd;

import org.jbpm.api.JbpmException;
import org.jbpm.api.cmd.Command;
import org.jbpm.api.cmd.Environment;
import org.jbpm.api.model.ActivityCoordinates;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;
import org.jbpm.pvm.internal.session.RepositorySession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetActivityCoordinatesCmd
implements Command<ActivityCoordinates> {
    private static final long serialVersionUID = 1L;
    String processDefinitionId;
    String activityName;

    public GetActivityCoordinatesCmd(String processDefinitionId, String activityName) {
        this.processDefinitionId = processDefinitionId;
        this.activityName = activityName;
    }

    public ActivityCoordinates execute(Environment environment) throws Exception {
        RepositorySession repositorySession = (RepositorySession)environment.get(RepositorySession.class);
        ProcessDefinitionImpl processDefinition = repositorySession.findProcessDefinitionById(this.processDefinitionId);
        if (processDefinition == null) {
            throw new JbpmException("process definition " + this.processDefinitionId + " doesn't exist");
        }
        ActivityImpl activity = processDefinition.findActivity(this.activityName);
        if (activity == null) {
            throw new JbpmException("activity '" + this.activityName + "' doesn't exist in process definition " + this.processDefinitionId);
        }
        return activity.getCoordinates();
    }
}

