/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.timer.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.job.Job;
import org.jbpm.test.JbpmTestCase;

public class TimerEventTest
extends JbpmTestCase {
    String deploymentId;

    protected void setUp() throws Exception {
        super.setUp();
        this.deploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/examples/timer/event/process.jpdl.xml").deploy();
    }

    protected void tearDown() throws Exception {
        this.repositoryService.deleteDeploymentCascade(this.deploymentId);
        super.tearDown();
    }

    public void testTimerEventTimerFires() {
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("TimerEvent");
        Job job = this.managementService.createJobQuery().processInstanceId(processInstance.getId()).uniqueResult();
        this.managementService.executeJob(job.getId());
        processInstance = this.executionService.findProcessInstanceById(processInstance.getId());
        Set<String> expectedActivityNames = Collections.singleton("guardedWait");
        TimerEventTest.assertEquals(expectedActivityNames, (Object)processInstance.findActiveActivityNames());
        TimerEventTest.assertEquals((Object)Boolean.TRUE, (Object)this.executionService.getVariable(processInstance.getId(), "escalation"));
    }

    public void testTimerEventContinueBeforeTimerFires() {
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("TimerEvent");
        String executionId = processInstance.findActiveExecutionIn("guardedWait").getId();
        this.executionService.signalExecutionById(executionId, "go on");
        processInstance = this.executionService.findProcessInstanceById(processInstance.getId());
        TimerEventTest.assertTrue((boolean)processInstance.isActive("next step"));
        List jobs = this.managementService.createJobQuery().processInstanceId(processInstance.getId()).list();
        TimerEventTest.assertEquals(new ArrayList(), new ArrayList(jobs));
    }
}

