/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.timer.businesstime;

import org.jbpm.api.ProcessInstance;
import org.jbpm.api.job.Job;
import org.jbpm.test.JbpmTestCase;

public class TimerBusinessTimeTest
extends JbpmTestCase {
    static long HOUR_IN_MILLIS = 360000L;
    String deploymentId;

    protected void setUp() throws Exception {
        super.setUp();
        this.deploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/examples/timer/businesstime/process.jpdl.xml").deploy();
    }

    protected void tearDown() throws Exception {
        this.repositoryService.deleteDeploymentCascade(this.deploymentId);
        super.tearDown();
    }

    public void testBusinessTime() {
        long now = System.currentTimeMillis();
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("TimerBusinessTime");
        Job job = this.managementService.createJobQuery().processInstanceId(processInstance.getId()).uniqueResult();
        long difference = job.getDuedate().getTime() - now;
        TimerBusinessTimeTest.assertTrue((24L * HOUR_IN_MILLIS < difference ? 1 : 0) != 0);
    }
}

