/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.task.candidates;

import java.util.List;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;

public class TaskCandidatesTest
extends JbpmTestCase {
    String deploymentId;
    String dept;

    protected void setUp() throws Exception {
        super.setUp();
        this.dept = this.identityService.createGroup("sales-dept");
        this.identityService.createUser("johndoe", "John", "Doe");
        this.identityService.createMembership("johndoe", this.dept, "developer");
        this.identityService.createUser("joesmoe", "Joe", "Smoe");
        this.identityService.createMembership("joesmoe", this.dept, "developer");
        this.deploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/examples/task/candidates/process.jpdl.xml").deploy();
    }

    protected void tearDown() throws Exception {
        this.repositoryService.deleteDeploymentCascade(this.deploymentId);
        this.identityService.deleteGroup(this.dept);
        this.identityService.deleteUser("johndoe");
        this.identityService.deleteUser("joesmoe");
        super.tearDown();
    }

    public void testGroupCandidateAssignment() {
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("TaskCandidates");
        String pid = processInstance.getId();
        List taskList = this.taskService.findGroupTasks("johndoe");
        TaskCandidatesTest.assertEquals((String)"Expected a single task in johndoe's task list", (int)1, (int)taskList.size());
        Task task = (Task)taskList.get(0);
        TaskCandidatesTest.assertEquals((String)"review", (String)task.getName());
        taskList = this.taskService.findGroupTasks("joesmoe");
        TaskCandidatesTest.assertEquals((String)"Expected a single task in joesmoe's group task list", (int)1, (int)taskList.size());
        task = (Task)taskList.get(0);
        TaskCandidatesTest.assertEquals((String)"review", (String)task.getName());
        taskList = this.taskService.findPersonalTasks("johndoe");
        TaskCandidatesTest.assertEquals((int)0, (int)taskList.size());
        taskList = this.taskService.findPersonalTasks("joesmoe");
        TaskCandidatesTest.assertEquals((int)0, (int)taskList.size());
        this.taskService.takeTask(task.getId(), "johndoe");
        taskList = this.taskService.findGroupTasks("johndoe");
        TaskCandidatesTest.assertEquals((int)0, (int)taskList.size());
        taskList = this.taskService.findGroupTasks("joesmoe");
        TaskCandidatesTest.assertEquals((int)0, (int)taskList.size());
        taskList = this.taskService.findPersonalTasks("johndoe");
        TaskCandidatesTest.assertEquals((String)"Expected a single task being created", (int)1, (int)taskList.size());
        task = (Task)taskList.get(0);
        TaskCandidatesTest.assertEquals((String)"review", (String)task.getName());
        TaskCandidatesTest.assertEquals((String)"johndoe", (String)task.getAssignee());
        taskList = this.taskService.findPersonalTasks("joesmoe");
        TaskCandidatesTest.assertEquals((int)0, (int)taskList.size());
        this.taskService.completeTask(task.getId());
        taskList = this.taskService.findPersonalTasks("johndoe");
        TaskCandidatesTest.assertEquals((int)0, (int)taskList.size());
        processInstance = this.executionService.findProcessInstanceById(pid);
        TaskCandidatesTest.assertTrue((boolean)processInstance.isActive("wait"));
    }
}

