/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.subprocess.variables;

import java.util.HashMap;
import java.util.List;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;

public class SubProcessVariablesTest
extends JbpmTestCase {
    String subProcessReviewDeploymentId;
    String subProcessDocumentDeploymentId;

    protected void setUp() throws Exception {
        super.setUp();
        this.subProcessReviewDeploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/examples/subprocess/variables/SubProcessReview.jpdl.xml").deploy();
        this.subProcessDocumentDeploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/examples/subprocess/variables/SubProcessDocument.jpdl.xml").deploy();
    }

    protected void tearDown() throws Exception {
        this.repositoryService.deleteDeploymentCascade(this.subProcessReviewDeploymentId);
        this.repositoryService.deleteDeploymentCascade(this.subProcessDocumentDeploymentId);
        super.tearDown();
    }

    public void testSubProcessVariables() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("document", "This document describes how we can make more money...");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("SubProcessDocument", variables);
        SubProcessVariablesTest.assertNotNull((Object)processInstance.findActiveExecutionIn("review"));
        List taskList = this.taskService.findPersonalTasks("johndoe");
        Task task = (Task)taskList.get(0);
        String document = (String)this.taskService.getVariable(task.getId(), "document");
        SubProcessVariablesTest.assertEquals((String)"This document describes how we can make more money...", (String)document);
        variables = new HashMap();
        variables.put("result", "accept");
        this.taskService.setVariables(task.getId(), variables);
        this.taskService.completeTask(task.getId());
        processInstance = this.executionService.findProcessInstanceById(processInstance.getId());
        SubProcessVariablesTest.assertNotNull((Object)processInstance.findActiveExecutionIn("wait"));
        String result = (String)this.executionService.getVariable(processInstance.getId(), "reviewResult");
        SubProcessVariablesTest.assertEquals((String)"accept", (String)result);
    }
}

