/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.serializablevariable;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.jbpm.api.ProcessInstance;
import org.jbpm.test.JbpmTestCase;

public class SerializableVariableTest
extends JbpmTestCase {
    String deploymentId;

    protected void setUp() throws Exception {
        super.setUp();
        this.deploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/examples/serializablevariable/process.jpdl.xml").deploy();
    }

    protected void tearDown() throws Exception {
        this.repositoryService.deleteDeploymentCascade(this.deploymentId);
        super.tearDown();
    }

    public void testSerializableVariableUpdate() {
        Set<String> messages = new HashSet<String>();
        messages.add("serialize");
        messages.add("me");
        HashMap<String, HashSet<String>> variables = new HashMap<String, HashSet<String>>();
        variables.put("messages", (HashSet<String>)messages);
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("SerializableVariable", variables);
        String pid = processInstance.getId();
        this.executionService.signalExecutionById(pid);
        HashSet<String> expectedMessages = new HashSet<String>();
        expectedMessages.add("i");
        expectedMessages.add("was");
        expectedMessages.add("updated");
        messages = (Set)this.executionService.getVariable(pid, "messages");
        SerializableVariableTest.assertEquals(expectedMessages, messages);
    }
}

