/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.mail.template;

import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.jbpm.test.JbpmTestCase;
import org.subethamail.wiser.Wiser;
import org.subethamail.wiser.WiserMessage;

public class TemplateMailTest
extends JbpmTestCase {
    private Wiser wiser = new Wiser();

    protected void setUp() throws Exception {
        super.setUp();
        String deploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/examples/mail/template/process.jpdl.xml").deploy();
        this.registerDeployment(deploymentId);
        this.identityService.createUser("bb", "Big Brother", null, "bb@oceania");
        this.identityService.createUser("obrien", null, "O'Brien", "obrien@miniluv");
        this.identityService.createUser("charr", null, "Charrington", "charr@miniluv");
        this.identityService.createGroup("thinkpol");
        this.identityService.createGroup("innerparty");
        this.identityService.createMembership("obrien", "innerparty");
        this.identityService.createMembership("charr", "thinkpol");
        this.identityService.createMembership("obrien", "thinkpol");
        this.wiser.setPort(2525);
        this.wiser.start();
    }

    protected void tearDown() throws Exception {
        this.wiser.stop();
        this.identityService.deleteGroup("thinkpol");
        this.identityService.deleteGroup("innerparty");
        this.identityService.deleteUser("bb");
        this.identityService.deleteUser("obrien");
        this.identityService.deleteUser("charr");
        super.tearDown();
    }

    public void testTemplateMail() throws MessagingException, IOException {
        String addressee = "winston@minitrue";
        String newspaper = "times";
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1983, 11, 3);
        Date date = calendar.getTime();
        String details = "reporting bb dayorder doubleplusungood refs unpersons rewrite fullwise upsub antefiling";
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("addressee", addressee);
        variables.put("newspaper", newspaper);
        variables.put("date", date);
        variables.put("details", details);
        this.executionService.startProcessInstanceByKey("TemplateMail", variables);
        List wisMessages = this.wiser.getMessages();
        TemplateMailTest.assertEquals((int)5, (int)wisMessages.size());
        for (WiserMessage wisMessage : wisMessages) {
            MimeMessage message = wisMessage.getMimeMessage();
            Address[] from = message.getFrom();
            TemplateMailTest.assertEquals((int)1, (int)from.length);
            TemplateMailTest.assertEquals((String)"noreply@jbpm.org", (String)from[0].toString());
            Object[] expectedTo = InternetAddress.parse((String)addressee);
            Object[] to = message.getRecipients(Message.RecipientType.TO);
            assert (Arrays.equals(expectedTo, to)) : Arrays.asList(to);
            Object[] expectedCc = InternetAddress.parse((String)"bb@oceania, obrien@miniluv");
            Object[] cc = message.getRecipients(Message.RecipientType.CC);
            assert (Arrays.equals(expectedCc, cc)) : Arrays.asList(cc);
            TemplateMailTest.assertNull((Object)message.getRecipients(Message.RecipientType.BCC));
            TemplateMailTest.assertEquals((String)("rectify " + newspaper), (String)message.getSubject());
            TemplateMailTest.assertEquals((String)(newspaper + ' ' + date + ' ' + details), (String)((String)message.getContent()));
        }
    }
}

