/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.hql;

import java.util.HashSet;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;

public class HqlTest
extends JbpmTestCase {
    String deploymentId;
    String taskLaundryId;
    String taskDishesId;
    String taskIronId;

    protected void setUp() throws Exception {
        super.setUp();
        this.deploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/examples/hql/process.jpdl.xml").deploy();
        Task task = this.taskService.newTask();
        task.setName("laundry");
        this.taskLaundryId = this.taskService.saveTask(task);
        task = this.taskService.newTask();
        task.setName("dishes");
        this.taskDishesId = this.taskService.saveTask(task);
        task = this.taskService.newTask();
        task.setName("iron");
        this.taskIronId = this.taskService.saveTask(task);
    }

    protected void tearDown() throws Exception {
        this.repositoryService.deleteDeploymentCascade(this.deploymentId);
        this.taskService.deleteTaskCascade(this.taskLaundryId);
        this.taskService.deleteTaskCascade(this.taskDishesId);
        this.taskService.deleteTaskCascade(this.taskIronId);
        super.tearDown();
    }

    public void testHql() {
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("Hql");
        String processInstanceId = processInstance.getId();
        HashSet<String> expectedTaskNames = new HashSet<String>();
        expectedTaskNames.add("dishes");
        expectedTaskNames.add("iron");
        HashSet taskNames = (HashSet)this.executionService.getVariable(processInstanceId, "tasknames with i");
        taskNames = new HashSet(taskNames);
        HqlTest.assertEquals(expectedTaskNames, taskNames);
        Object activities = this.executionService.getVariable(processInstanceId, "tasks");
        HqlTest.assertEquals((String)"3", (String)activities.toString());
    }
}

