/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.testutils.jbr;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.management.MBeanServer;
import junit.framework.TestCase;
import org.jboss.internal.soa.esb.util.StreamUtils;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.soa.esb.testutils.StringUtils;

public class StaticRequestResponseHandler
implements ServerInvocationHandler {
    private String response;
    private String expectedRequest;

    public StaticRequestResponseHandler(String response) {
        this.response = response;
    }

    public StaticRequestResponseHandler(InputStream response) {
        this.response = this.readStream(response);
    }

    public void setExpectedRequest(String expectedRequest) {
        this.expectedRequest = expectedRequest;
    }

    public void setExpectedRequest(InputStream expectedRequest) {
        this.expectedRequest = this.readStream(expectedRequest);
    }

    public Object invoke(InvocationRequest invocationRequest) throws Throwable {
        if (this.expectedRequest != null) {
            String payload = (String)invocationRequest.getParameter();
            TestCase.assertTrue((boolean)StringUtils.equalsIgnoreLinebreaks(this.expectedRequest, payload, false));
        }
        return this.response;
    }

    private String readStream(InputStream response) {
        try {
            String string = StreamUtils.readStreamString((InputStream)response, (String)"UTF-8");
            return string;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error reading stream.");
        }
        finally {
            try {
                response.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Error closing stream.");
            }
        }
    }

    public void setMBeanServer(MBeanServer mBeanServer) {
    }

    public void setInvoker(ServerInvoker serverInvoker) {
    }

    public void addListener(InvokerCallbackHandler invokerCallbackHandler) {
    }

    public void removeListener(InvokerCallbackHandler invokerCallbackHandler) {
    }
}

