/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.testutils.jbr;

import java.util.HashMap;
import java.util.Map;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.transport.Connector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBRServer {
    private String serverURI;
    private Connector connector;
    private boolean isStarted = false;

    public JBRServer(String serverURI, ServerInvocationHandler handler) throws Exception {
        this(serverURI, handler, new HashMap<String, String>());
    }

    public JBRServer(String serverURI, ServerInvocationHandler handler, Map<String, String> connectorConfig) throws Exception {
        InvokerLocator locator = new InvokerLocator(serverURI);
        this.serverURI = serverURI;
        this.connector = new Connector(locator, connectorConfig);
        this.connector.create();
        this.connector.addInvocationHandler(handler.getClass().getName(), handler);
    }

    public void start() throws Exception {
        if (this.isStarted) {
            throw new RuntimeException("Server '" + this.serverURI + "' already started.");
        }
        this.connector.start();
        this.isStarted = true;
    }

    public void stop() {
        if (!this.isStarted) {
            throw new RuntimeException("Server '" + this.serverURI + "' not started.");
        }
        this.connector.stop();
        this.isStarted = false;
    }
}

