/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.testutils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.testutils.FileUtil;
import org.jboss.soa.esb.testutils.HsqldbUtil;

public class TestEnvironmentUtil {
    private static Logger log = Logger.getLogger(TestEnvironmentUtil.class);

    public static String getUserDir() {
        return TestEnvironmentUtil.getUserDir("product");
    }

    public static String getBaseDir() {
        return System.getProperty("user.dir");
    }

    public static String getUserDir(String dir) {
        String userDir = "";
        String baseDir = System.getProperty("user.dir");
        log.debug((Object)baseDir);
        if (!baseDir.endsWith(dir)) {
            userDir = dir + "/";
        }
        return userDir;
    }

    public static String getUserDir(String eclipseDir, String antDir) {
        String userDir = "";
        String baseDir = System.getProperty("user.dir");
        log.debug((Object)baseDir);
        userDir = !baseDir.endsWith(eclipseDir) ? (baseDir.endsWith("qa") ? antDir + "/" : eclipseDir + "/") : antDir + "/";
        log.debug((Object)userDir);
        return userDir;
    }

    public static void setESBPropertiesFileToUse() {
        String jbossesbPropertiesFile = TestEnvironmentUtil.getUserDir() + "/etc/test/resources/jbossesb-unittest-properties.xml";
        System.setProperty("org.jboss.soa.esb.propertyFile", jbossesbPropertiesFile);
    }

    public static void setESBPropertiesFileToUse(String dir) {
        String jbossesbPropertiesFile = TestEnvironmentUtil.getUserDir(dir) + "/etc/test/resources/jbossesb-unittest-properties.xml";
        System.setProperty("org.jboss.soa.esb.propertyFile", jbossesbPropertiesFile);
    }

    public static void setESBPropertiesFileToUse(String eclipseDir, String antDir) {
        String jbossesbPropertiesFile = TestEnvironmentUtil.getUserDir(eclipseDir, antDir) + "/etc/test/resources/jbossesb-unittest-properties.xml";
        System.setProperty("org.jboss.soa.esb.propertyFile", jbossesbPropertiesFile);
    }

    public static String readTextFile(File file) throws IOException {
        StringBuffer sb = new StringBuffer(1024);
        BufferedReader reader = new BufferedReader(new FileReader(file.getPath()));
        char[] chars = new char[1];
        while (reader.read(chars) > -1) {
            sb.append(String.valueOf(chars));
            chars = new char[1];
        }
        reader.close();
        return sb.toString();
    }

    public static File findResourceDirectory(String dirPath) {
        String[] dirs = dirPath.split("/");
        for (int i = 1; i < dirs.length; ++i) {
            dirPath = ".";
            for (int j = i; j < dirs.length; ++j) {
                dirPath = dirPath + "/" + dirs[j];
            }
            File dir = new File(dirPath);
            if (!dir.exists()) continue;
            return dir;
        }
        return null;
    }

    public static void startJAXRDatabase() throws SQLException {
        Properties props = TestEnvironmentUtil.getJuddiProperties();
        String mDbDriver = props.getProperty("juddi.jdbcDriver");
        String mDbUrl = props.getProperty("juddi.jdbcUrl");
        String mDbUsername = props.getProperty("juddi.jdbcUsername");
        String mDbPassword = props.getProperty("juddi.jdbcPassword");
        String database = "not tested yet";
        if ("org.hsqldb.jdbcDriver".equals(mDbDriver)) {
            database = "hsqldb";
            try {
                HsqldbUtil.startHsqldb(TestEnvironmentUtil.getProductDir() + "build/hsqltestdb", "juddi");
            }
            catch (Exception e) {
                TestCase.fail((String)("Failed to start HSQLDB: " + e.getMessage()));
            }
        } else if ("com.mysql.jdbc.Driver".equals(mDbDriver)) {
            database = "mysql";
        }
        String sqlDir = TestEnvironmentUtil.getProductDir() + "install/jUDDI-registry/sql/" + database + "/";
        String sqlDropCmd = null;
        try {
            sqlDropCmd = FileUtil.readTextFile(new File(sqlDir + "drop_database.sql")).replaceAll("\\$\\{prefix}", "");
        }
        catch (IOException e) {
            TestCase.fail((String)("Failed to read drop_database.sql: " + e.getMessage()));
        }
        String resource = "juddi-sql/" + database + "/create_database.sql";
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
        String sqlCreateCmd = null;
        try {
            sqlCreateCmd = FileUtil.readStream(is).trim().replaceAll("\\$\\{prefix}", "");
        }
        catch (Exception e) {
            TestCase.fail((String)("Failed to read '" + resource + "' from classpath: " + e.getMessage()));
        }
        String sqlInsertPubCmd = null;
        try {
            sqlInsertPubCmd = FileUtil.readTextFile(new File(sqlDir + "import.sql")).trim().replaceAll("\\$\\{prefix}", "");
        }
        catch (IOException e) {
            TestCase.fail((String)("Failed to read import.sql: " + e.getMessage()));
        }
        try {
            Class.forName(mDbDriver);
        }
        catch (Exception e) {
            TestCase.fail((String)("ERROR: failed to load " + database + " JDBC driver: " + e.getMessage()));
            return;
        }
        Connection con = DriverManager.getConnection(mDbUrl, mDbUsername, mDbPassword);
        Statement stmnt = con.createStatement();
        System.out.println("Dropping the schema if exist");
        stmnt.execute(sqlDropCmd);
        System.out.println("Creating the juddi-schema");
        stmnt.execute(sqlCreateCmd);
        System.out.println("Adding the jbossesb publisher");
        stmnt.execute(sqlInsertPubCmd);
    }

    public static String getProductDir() {
        File parentDir;
        File workingDir = new File(new File("./").getAbsolutePath());
        if (TestEnvironmentUtil.isProjectRootDir(workingDir)) {
            return "product/";
        }
        StringBuilder stringBuilder = new StringBuilder("product/");
        for (parentDir = workingDir.getParentFile(); parentDir != null && !TestEnvironmentUtil.isProjectRootDir(parentDir); parentDir = parentDir.getParentFile()) {
            stringBuilder.insert(0, "../");
        }
        if (parentDir == null) {
            throw new RuntimeException("Unable to establish the relative location of the project's 'product' directory from current working directory '" + workingDir.getAbsolutePath() + "'.");
        }
        return stringBuilder.toString();
    }

    private static boolean isProjectRootDir(File dir) {
        return new File(dir, "product/services/jbossesb").exists();
    }

    public static void stopJAXRDatabase() throws Exception {
        Properties props = TestEnvironmentUtil.getJuddiProperties();
        String mDbDriver = props.getProperty("juddi.jdbcDriver");
        String mDbUrl = props.getProperty("juddi.jdbcUrl");
        String mDbUsername = props.getProperty("juddi.jdbcUsername");
        String mDbPassword = props.getProperty("juddi.jdbcPassword");
        if ("org.hsqldb.jdbcDriver".equals(mDbDriver)) {
            HsqldbUtil.stopHsqldb(mDbUrl, mDbUsername, mDbPassword);
        }
    }

    private static Properties getJuddiProperties() {
        String juddiPropertiesFile = "/org/jboss/soa/esb/testutils/juddi-unittest.properties";
        System.setProperty("juddi.propertiesFile", juddiPropertiesFile);
        Properties props = new Properties();
        InputStream inStream = Class.class.getResourceAsStream(juddiPropertiesFile);
        try {
            props.load(inStream);
        }
        catch (IOException e) {
            TestCase.fail((String)"Failed to load juddi properties.");
        }
        return props;
    }
}

