/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.testutils;

import com.arjuna.common.util.propertyservice.PropertyManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Hashtable;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.internal.soa.esb.couriers.MockCourierFactory;
import org.jboss.internal.soa.esb.services.registry.JAXRRegistryImpl;
import org.jboss.internal.soa.esb.services.registry.MockRegistry;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.common.ModulePropertyManager;
import org.jboss.soa.esb.dom.YADOMUtil;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.config.ConfigurationController;
import org.jboss.soa.esb.listeners.config.Generator;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleController;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleException;
import org.jboss.soa.esb.parameters.ParamRepositoryException;
import org.jboss.soa.esb.services.registry.Registry;
import org.jboss.soa.esb.services.registry.RegistryException;
import org.jboss.soa.esb.services.registry.RegistryFactory;
import org.jboss.soa.esb.testutils.TestEnvironmentUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ESBConfigUtil {
    private Generator generator;
    private Document listenerConfig;
    private Document gatewayConfig;
    private ManagedLifecycleController controller;
    private boolean installMockCourierFactory = true;
    private boolean installMockRegistry = true;
    private Hashtable<String, PropertyManager> originalPropertyManagers;
    private Registry originalRegistry;

    public ESBConfigUtil(InputStream esbXsdConfig) throws IOException, ConfigurationException, SAXException {
        AssertArgument.isNotNull((Object)esbXsdConfig, (String)"esbXsdConfig");
        ByteArrayOutputStream listenerConfigStream = new ByteArrayOutputStream();
        ByteArrayOutputStream gatewayConfigStream = new ByteArrayOutputStream();
        this.generator = null;
        this.generator = new Generator(esbXsdConfig, (OutputStream)listenerConfigStream, (OutputStream)gatewayConfigStream);
        this.generator.generate();
        this.listenerConfig = YADOMUtil.parseStream((InputStream)new ByteArrayInputStream(listenerConfigStream.toByteArray()), (boolean)false, (boolean)false);
        this.gatewayConfig = YADOMUtil.parseStream((InputStream)new ByteArrayInputStream(gatewayConfigStream.toByteArray()), (boolean)false, (boolean)false);
    }

    public void setESBProperties(InputStream esbProperties) throws IOException, ConfigurationException, SAXException {
        this.originalPropertyManagers = (Hashtable)ModulePropertyManager.getManagers().clone();
        ModulePropertyManager.configure((InputStream)esbProperties);
    }

    public void resetESBProperties() {
        if (this.originalPropertyManagers != null) {
            ModulePropertyManager.setManagers(this.originalPropertyManagers);
            this.originalPropertyManagers = null;
        }
    }

    public void installRegistry() {
        this.originalRegistry = RegistryFactory.getRegistrySingleton();
        Registry newRegistry = null;
        try {
            newRegistry = RegistryFactory.createRegistry();
            RegistryFactory.setRegistry((Registry)newRegistry);
        }
        catch (RegistryException e) {
            throw new RuntimeException("Failed to create registry instance.", e);
        }
        if (newRegistry instanceof JAXRRegistryImpl) {
            try {
                TestEnvironmentUtil.startJAXRDatabase();
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to start JAXR Database.", e);
            }
            this.installMockCourierFactory = false;
            this.installMockRegistry = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstallRegistry() {
        block5: {
            try {
                Registry currentRegistry = RegistryFactory.getRegistrySingleton();
                if (!(currentRegistry instanceof JAXRRegistryImpl)) break block5;
                try {
                    TestEnvironmentUtil.stopJAXRDatabase();
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to stop JAXR Database.", e);
                }
            }
            finally {
                RegistryFactory.setRegistry((Registry)this.originalRegistry);
            }
        }
    }

    public boolean isInstallMockCourierFactory() {
        return this.installMockCourierFactory;
    }

    public void setInstallMockCourierFactory(boolean installMockCourierFactory) {
        this.installMockCourierFactory = installMockCourierFactory;
    }

    public boolean isInstallMockRegistry() {
        return this.installMockRegistry;
    }

    public void setInstallMockRegistry(boolean installMockRegistry) {
        this.installMockRegistry = installMockRegistry;
    }

    public ConfigTree getListenerConfig(String listenerName) {
        AssertArgument.isNotNull((Object)listenerName, (String)"listenerName");
        return ConfigTree.fromElement((Element)this.getListenerConfig(listenerName, this.listenerConfig));
    }

    public ConfigTree getGatewayConfig(String gatewayName) {
        AssertArgument.isNotNull((Object)gatewayName, (String)"gatewayName");
        return ConfigTree.fromElement((Element)this.getListenerConfig(gatewayName, this.gatewayConfig));
    }

    private Element getListenerConfig(String name, Document config) {
        NodeList listenerConfigElements = config.getDocumentElement().getElementsByTagName(name);
        if (listenerConfigElements == null || listenerConfigElements.getLength() == 0) {
            listenerConfigElements = config.getDocumentElement().getElementsByTagName("listener");
            if (listenerConfigElements == null || listenerConfigElements.getLength() == 0) {
                return null;
            }
            for (int i = 0; i < listenerConfigElements.getLength(); ++i) {
                Element element = (Element)listenerConfigElements.item(i);
                if (!name.equals(element.getAttribute("name"))) continue;
                return element;
            }
            return null;
        }
        return (Element)listenerConfigElements.item(0);
    }

    public ConfigTree getActionConfig(String listenerName, String actionName) {
        AssertArgument.isNotNull((Object)listenerName, (String)"listenerName");
        AssertArgument.isNotNull((Object)actionName, (String)"actionName");
        Element listener = this.getListenerConfig(listenerName, this.listenerConfig);
        NodeList actions = listener.getElementsByTagName("action");
        if (actions == null || actions.getLength() == 0) {
            return null;
        }
        for (int i = 0; i < actions.getLength(); ++i) {
            Element action = (Element)actions.item(i);
            if (!actionName.equals(action.getAttribute("action"))) continue;
            return ConfigTree.fromElement((Element)action);
        }
        return null;
    }

    public Document getListenerConfig() {
        return this.listenerConfig;
    }

    public Document getGatewayConfig() {
        return this.gatewayConfig;
    }

    public void startController() throws ParamRepositoryException, ConfigurationException, ManagedLifecycleException, SAXException {
        if (this.controller != null) {
            throw new RuntimeException("Sorry, this ESBConfigUtil instance has already been started/used.  You cannot restart!");
        }
        ConfigTree listenerConfigTree = ConfigTree.fromElement((Element)this.listenerConfig.getDocumentElement());
        ConfigTree gatewayConfigTree = ConfigTree.fromElement((Element)this.gatewayConfig.getDocumentElement());
        if (this.installMockCourierFactory) {
            MockCourierFactory.install();
        }
        if (this.installMockRegistry) {
            MockRegistry.install();
        }
        this.controller = ConfigurationController.startController((Generator.XMLBeansModel)this.generator.getModel(), (ConfigTree)listenerConfigTree, (ConfigTree)gatewayConfigTree);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopController() {
        try {
            ConfigurationController.stopController((ManagedLifecycleController)this.controller);
        }
        finally {
            try {
                try {
                    if (this.installMockRegistry) {
                        MockRegistry.uninstall();
                    }
                }
                finally {
                    if (this.installMockCourierFactory) {
                        MockCourierFactory.uninstall();
                    }
                }
            }
            finally {
                this.resetESBProperties();
            }
        }
    }
}

