/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.testutils;

import java.io.InputStream;
import junit.framework.TestCase;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.soa.esb.common.ModulePropertyManager;
import org.jboss.soa.esb.testutils.ESBConfigUtil;

public abstract class AbstractTestRunner {
    private InputStream serviceConfig;
    private InputStream esbProperties;

    public AbstractTestRunner setServiceConfig(InputStream serviceConfig) {
        AssertArgument.isNotNull((Object)serviceConfig, (String)"serviceConfig");
        this.serviceConfig = serviceConfig;
        return this;
    }

    public AbstractTestRunner setServiceConfig(String serviceConfig) {
        AssertArgument.isNotNull((Object)serviceConfig, (String)"serviceConfig");
        this.setServiceConfig(this.getClass().getResourceAsStream(serviceConfig));
        return this;
    }

    public AbstractTestRunner setEsbProperties(InputStream esbProperties) {
        AssertArgument.isNotNull((Object)esbProperties, (String)"esbProperties");
        this.esbProperties = esbProperties;
        return this;
    }

    public AbstractTestRunner setEsbProperties(String esbProperties) {
        AssertArgument.isNotNull((Object)esbProperties, (String)"esbProperties");
        this.setEsbProperties(this.getClass().getResourceAsStream(esbProperties));
        return this;
    }

    public abstract void test() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        if (this.serviceConfig == null) {
            TestCase.fail((String)"'serviceConfig' not configured.  Must call setServiceConfig().");
        }
        ESBConfigUtil esbConfig = new ESBConfigUtil(this.serviceConfig);
        if (this.esbProperties != null) {
            esbConfig.setESBProperties(this.esbProperties);
        } else {
            esbConfig.setESBProperties(AbstractTestRunner.class.getResourceAsStream("jbossesb-properties.xml"));
        }
        String installedJaxrConnectionFactoryImpl = System.getProperty("javax.xml.registry.ConnectionFactoryClass");
        String jaxrConnectionFactoryImpl = ModulePropertyManager.getPropertyManager((String)"registry").getProperty("org.jboss.soa.esb.registry.factoryClass", "org.apache.ws.scout.registry.ConnectionFactoryImpl");
        System.setProperty("javax.xml.registry.ConnectionFactoryClass", jaxrConnectionFactoryImpl);
        try {
            esbConfig.installRegistry();
            try {
                esbConfig.startController();
                try {
                    this.test();
                }
                finally {
                    esbConfig.stopController();
                }
            }
            finally {
                esbConfig.uninstallRegistry();
            }
        }
        finally {
            if (installedJaxrConnectionFactoryImpl != null) {
                System.setProperty("javax.xml.registry.ConnectionFactoryClass", installedJaxrConnectionFactoryImpl);
            } else {
                System.getProperties().remove("javax.xml.registry.ConnectionFactoryClass");
            }
            esbConfig.resetESBProperties();
        }
    }
}

