/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.services.registry;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.jboss.internal.soa.esb.services.registry.MockRegistry;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.services.registry.RegistryException;
import org.jboss.soa.esb.services.registry.ServiceNotFoundException;

public class MockRegistryUnitTest
extends TestCase {
    public void test_install_uninstall() throws RegistryException {
        MockRegistryUnitTest.assertNotSame((Object)MockRegistry.class.getName(), (Object)MockRegistry.regPropManager.getProperty("org.jboss.soa.esb.registry.implementationClass"));
        MockRegistry.install();
        MockRegistryUnitTest.assertEquals((String)MockRegistry.class.getName(), (String)MockRegistry.regPropManager.getProperty("org.jboss.soa.esb.registry.implementationClass"));
        MockRegistry.uninstall();
        MockRegistryUnitTest.assertNotSame((Object)MockRegistry.class.getName(), (Object)MockRegistry.regPropManager.getProperty("org.jboss.soa.esb.registry.implementationClass"));
    }

    public void test_features() throws RegistryException, ServiceNotFoundException {
        MockRegistry registry = new MockRegistry();
        EPR epr = new EPR();
        ArrayList<String> services = new ArrayList<String>();
        ArrayList<EPR> eprs = new ArrayList<EPR>();
        registry.registerEPR("cat1", "cat1-service1", "service-desc", epr, "epr-desc");
        registry.registerEPR("cat1", "cat1-service2", "service-desc", epr, "epr-desc");
        registry.registerEPR("cat1", "cat1-service3", "service-desc", epr, "epr-desc");
        registry.registerEPR("cat2", "cat2-service1", "service-desc", epr, "epr-desc");
        registry.registerEPR("cat2", "cat2-service2", "service-desc", epr, "epr-desc");
        registry.registerEPR("cat2", "cat2-service3", "service-desc", epr, "epr-desc");
        services.addAll(registry.findAllServices());
        MockRegistryUnitTest.assertEquals((int)6, (int)services.size());
        MockRegistryUnitTest.assertEquals((String)"cat1-service1", (String)((String)services.get(0)));
        MockRegistryUnitTest.assertEquals((String)"cat2-service1", (String)((String)services.get(3)));
        MockRegistryUnitTest.assertEquals((String)"cat2-service3", (String)((String)services.get(5)));
        services.clear();
        services.addAll(registry.findServices("cat1"));
        MockRegistryUnitTest.assertEquals((int)3, (int)services.size());
        MockRegistryUnitTest.assertEquals((String)"cat1-service1", (String)((String)services.get(0)));
        MockRegistryUnitTest.assertEquals((String)"cat1-service2", (String)((String)services.get(1)));
        MockRegistryUnitTest.assertEquals((String)"cat1-service3", (String)((String)services.get(2)));
        MockRegistryUnitTest.assertEquals((Object)epr, (Object)registry.findEPR("cat1", "cat1-service1"));
        try {
            registry.unRegisterService("cat2", "cat1-service2");
            MockRegistryUnitTest.fail((String)"Expected RegistryException for unknown service.");
        }
        catch (ServiceNotFoundException e) {
            // empty catch block
        }
        eprs.addAll(registry.findEPRs("cat1", "cat1-service1"));
        MockRegistryUnitTest.assertEquals((int)1, (int)eprs.size());
        MockRegistryUnitTest.assertEquals((Object)epr, eprs.get(0));
        registry.unRegisterService("cat1", "cat1-service2");
        services.clear();
        services.addAll(registry.findAllServices());
        MockRegistryUnitTest.assertEquals((int)5, (int)services.size());
        MockRegistryUnitTest.assertEquals((String)"cat1-service1", (String)((String)services.get(0)));
        MockRegistryUnitTest.assertEquals((String)"cat1-service3", (String)((String)services.get(1)));
        MockRegistryUnitTest.assertEquals((String)"cat2-service1", (String)((String)services.get(2)));
        registry.unRegisterEPR("cat2", "cat2-service2", epr);
        services.clear();
        services.addAll(registry.findAllServices());
        MockRegistryUnitTest.assertEquals((int)4, (int)services.size());
        MockRegistryUnitTest.assertEquals((String)"cat1-service1", (String)((String)services.get(0)));
        MockRegistryUnitTest.assertEquals((String)"cat1-service3", (String)((String)services.get(1)));
        MockRegistryUnitTest.assertEquals((String)"cat2-service1", (String)((String)services.get(2)));
    }
}

