/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.services.registry;

import com.arjuna.common.util.propertyservice.PropertyManager;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.jboss.internal.soa.esb.couriers.MockCourier;
import org.jboss.internal.soa.esb.couriers.MockCourierFactory;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.common.ModulePropertyManager;
import org.jboss.soa.esb.services.registry.Registry;
import org.jboss.soa.esb.services.registry.RegistryException;
import org.jboss.soa.esb.services.registry.ServiceNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockRegistry
implements Registry {
    private static final String REGISTRY_IMPEMENTATION_CLASS_ORIGINAL = "org.jboss.soa.esb.registry.implementationClass#Original";
    public static PropertyManager regPropManager = ModulePropertyManager.getPropertyManager((String)"registry");
    public static List<RepositoryEntry> repository = new ArrayList<RepositoryEntry>();

    public static void install() {
        String currentRegImpl;
        if (regPropManager == null) {
            TestCase.fail((String)"Failed to locate PropertyManager for [registry].");
        }
        if ((currentRegImpl = regPropManager.getProperty("org.jboss.soa.esb.registry.implementationClass")) != null) {
            regPropManager.setProperty(REGISTRY_IMPEMENTATION_CLASS_ORIGINAL, currentRegImpl);
        }
        regPropManager.setProperty("org.jboss.soa.esb.registry.implementationClass", MockRegistry.class.getName());
    }

    public static void uninstall() {
        String originalRegImpl;
        if (regPropManager == null) {
            TestCase.fail((String)"Failed to locate PropertyManager for [registry].");
        }
        if ((originalRegImpl = regPropManager.getProperty(REGISTRY_IMPEMENTATION_CLASS_ORIGINAL)) != null) {
            regPropManager.setProperty("org.jboss.soa.esb.registry.implementationClass", originalRegImpl);
            regPropManager.removeProperty(REGISTRY_IMPEMENTATION_CLASS_ORIGINAL);
        } else {
            regPropManager.removeProperty("org.jboss.soa.esb.registry.implementationClass");
        }
        repository = new ArrayList<RepositoryEntry>();
    }

    public static void register(String category, String service, MockCourier courier) {
        EPR epr = new EPR();
        MockRegistry.register(category, service, epr, courier);
    }

    public static void register(String category, String service, EPR epr, MockCourier courier) {
        repository.add(new RepositoryEntry(category, service, "", epr, ""));
        MockCourierFactory.couriers.put(epr, courier);
    }

    public void registerEPR(String serviceCategoryName, String serviceName, String serviceDescription, EPR epr, String eprDescription) throws RegistryException {
        repository.add(new RepositoryEntry(serviceCategoryName, serviceName, serviceDescription, epr, eprDescription));
    }

    public void unRegisterService(String category, String serviceName) throws RegistryException, ServiceNotFoundException {
        this.unRegisterEPR(category, serviceName, null);
    }

    public void unRegisterEPR(String serviceCategoryName, String serviceName, EPR epr) throws RegistryException, ServiceNotFoundException {
        int indexOf = repository.indexOf(new RepositoryEntry(serviceCategoryName, serviceName, null, epr, null));
        if (indexOf == -1) {
            throw new ServiceNotFoundException("Registry entry [" + serviceCategoryName + "][" + serviceName + "] not found.");
        }
        repository.remove(indexOf);
    }

    public List<String> findAllServices() throws RegistryException {
        ArrayList<String> services = new ArrayList<String>();
        for (RepositoryEntry entry : repository) {
            services.add(entry.serviceName);
        }
        return services;
    }

    public List<String> findServices(String serviceCategoryName) throws RegistryException {
        ArrayList<String> services = new ArrayList<String>();
        for (RepositoryEntry entry : repository) {
            if (!serviceCategoryName.equals(entry.serviceCategoryName)) continue;
            services.add(entry.serviceName);
        }
        return services;
    }

    public List<EPR> findEPRs(String serviceCategoryName, String serviceName) throws RegistryException {
        ArrayList<EPR> services = new ArrayList<EPR>();
        for (RepositoryEntry entry : repository) {
            if (!serviceCategoryName.equals(entry.serviceCategoryName) || !serviceName.equals(entry.serviceName)) continue;
            services.add(entry.epr);
        }
        return services;
    }

    public EPR findEPR(String serviceCategoryName, String serviceName) throws RegistryException, ServiceNotFoundException {
        for (RepositoryEntry entry : repository) {
            if (!serviceCategoryName.equals(entry.serviceCategoryName) || !serviceName.equals(entry.serviceName)) continue;
            return entry.epr;
        }
        throw new ServiceNotFoundException("Registry entry [" + serviceCategoryName + "][" + serviceName + "] not found.");
    }

    public static class RepositoryEntry {
        public String serviceCategoryName;
        public String serviceName;
        public String serviceDescription;
        public EPR epr;
        public String eprDescription;

        public RepositoryEntry(String serviceCategoryName, String serviceName, String serviceDescription, EPR epr, String eprDescription) {
            this.serviceCategoryName = serviceCategoryName;
            this.serviceName = serviceName;
            this.serviceDescription = serviceDescription;
            this.epr = epr;
            this.eprDescription = eprDescription;
        }

        public boolean equals(Object obj) {
            if (obj instanceof RepositoryEntry) {
                RepositoryEntry entry = (RepositoryEntry)obj;
                if (this.serviceCategoryName != null && !this.serviceCategoryName.equalsIgnoreCase(entry.serviceCategoryName)) {
                    return false;
                }
                if (this.serviceName != null && !this.serviceName.equalsIgnoreCase(entry.serviceName)) {
                    return false;
                }
                return this.epr == null || this.epr == entry.epr;
            }
            return false;
        }
    }
}

