/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.sim.kpi;

import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.sim.exception.ExperimentConfigurationException;
import org.jbpm.sim.kpi.BusinessFigureCalculator;

public class BusinessFigure {
    private String name;
    private String type;
    private Class implementationClass;
    private String expression;
    private double result = 0.0;

    public BusinessFigure(String name, String type, String implementationClass, String expression) {
        this.name = name;
        this.type = type;
        if (implementationClass != null) {
            try {
                this.implementationClass = Class.forName(implementationClass);
            }
            catch (ClassNotFoundException ex) {
                throw new ExperimentConfigurationException("business figure handler class '" + implementationClass + "' could not be loaded", ex);
            }
        } else {
            this.expression = expression;
        }
    }

    public BusinessFigure(String name, String type, Class implementationClass) {
        this.name = name;
        this.type = type;
        this.implementationClass = implementationClass;
    }

    public BusinessFigure(String name, String type, String expression) {
        this.name = name;
        this.type = type;
        this.expression = expression;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Class getImplementationClass() {
        return this.implementationClass;
    }

    public String getExpression() {
        return this.expression;
    }

    public Number calculateAndAdd(ExecutionContext executionContext) {
        Number result = null;
        if (this.implementationClass != null) {
            try {
                BusinessFigureCalculator calc = (BusinessFigureCalculator)this.implementationClass.newInstance();
                result = calc.calculate(executionContext);
            }
            catch (Exception ex) {
                throw new ExperimentConfigurationException("Couldn't initialize business figure handler of type " + this.implementationClass, ex);
            }
        } else {
            throw new RuntimeException("expressions in business figure calculation not yet implemented");
        }
        this.result += result.doubleValue();
        return result;
    }

    public double getResult() {
        return this.result;
    }

    public Object clone() {
        return this.copy();
    }

    public BusinessFigure copy() {
        if (this.implementationClass != null) {
            return new BusinessFigure(this.name, this.type, this.implementationClass);
        }
        return new BusinessFigure(this.name, this.type, this.expression);
    }
}

