/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.web;

import java.io.IOException;
import java.io.Serializable;
import java.security.Principal;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;

public class JbpmContextFilter
implements Filter,
Serializable {
    private static final long serialVersionUID = 2L;
    private JbpmConfiguration jbpmConfiguration;
    private String jbpmContextName;
    private boolean isAuthenticationEnabled = true;

    public void init(FilterConfig filterConfig) throws ServletException {
        String isAuthenticationEnabledText;
        String resource = filterConfig.getServletContext().getInitParameter("jbpm.configuration.resource");
        this.jbpmConfiguration = JbpmConfiguration.getInstance(resource);
        this.jbpmContextName = filterConfig.getInitParameter("jbpm.context.name");
        if (this.jbpmContextName == null) {
            this.jbpmContextName = "default.jbpm.context";
        }
        if ((isAuthenticationEnabledText = filterConfig.getInitParameter("authentication")) != null && "disabled".equalsIgnoreCase(isAuthenticationEnabledText)) {
            this.isAuthenticationEnabled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        JbpmContext jbpmContext = this.getJbpmConfiguration().createJbpmContext(this.jbpmContextName);
        try {
            HttpServletRequest httpServletRequest;
            Principal userPrincipal;
            if (this.isAuthenticationEnabled && servletRequest instanceof HttpServletRequest && (userPrincipal = (httpServletRequest = (HttpServletRequest)servletRequest).getUserPrincipal()) != null) {
                jbpmContext.setActorId(userPrincipal.getName());
            }
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            jbpmContext.close();
        }
    }

    protected JbpmConfiguration getJbpmConfiguration() {
        return this.jbpmConfiguration;
    }

    public void destroy() {
    }
}

