/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import org.jbpm.util.ArrayUtil;

public class CustomLoaderObjectInputStream
extends ObjectInputStream {
    private final ClassLoader customLoader;

    protected CustomLoaderObjectInputStream() throws IOException {
        this.customLoader = null;
    }

    public CustomLoaderObjectInputStream(InputStream in) throws IOException {
        this(in, Thread.currentThread().getContextClassLoader());
    }

    public CustomLoaderObjectInputStream(InputStream in, ClassLoader customLoader) throws IOException {
        super(in);
        if (customLoader == null) {
            throw new IllegalArgumentException("custom class loader is null");
        }
        this.customLoader = customLoader;
    }

    public ClassLoader getCustomLoader() {
        return this.customLoader;
    }

    protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        try {
            return super.resolveClass(desc);
        }
        catch (ClassNotFoundException e) {
            return Class.forName(desc.getName(), false, this.customLoader);
        }
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        try {
            return super.resolveProxyClass(interfaces);
        }
        catch (ClassNotFoundException e) {
            ClassLoader nonPublicLoader = null;
            Object[] classes = new Class[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                Class<?> cl = Class.forName(interfaces[i], false, this.customLoader);
                if ((cl.getModifiers() & 1) == 0) {
                    if (nonPublicLoader == null) {
                        nonPublicLoader = cl.getClassLoader();
                    } else if (nonPublicLoader != cl.getClassLoader()) {
                        throw new IllegalAccessError("conflicting non-public interface class loaders");
                    }
                }
                classes[i] = cl;
            }
            try {
                return Proxy.getProxyClass(nonPublicLoader != null ? nonPublicLoader : this.customLoader, classes);
            }
            catch (IllegalArgumentException iae) {
                throw new ClassNotFoundException("could not get proxy class for interfaces: " + ArrayUtil.toString(classes), e);
            }
        }
    }
}

