/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.scheduler.def;

import java.util.Calendar;
import java.util.Date;
import org.dom4j.Element;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.calendar.BusinessCalendar;
import org.jbpm.calendar.Duration;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.Event;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.job.Timer;
import org.jbpm.jpdl.el.impl.JbpmExpressionEvaluator;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.scheduler.SchedulerService;
import org.jbpm.util.Clock;

public class CreateTimerAction
extends Action {
    private static final long serialVersionUID = 1L;
    private String timerName;
    private String dueDate;
    private String repeat;
    private String transitionName;
    private Action timerAction;

    public void read(Element actionElement, JpdlXmlReader jpdlReader) {
        this.timerName = actionElement.attributeValue("name");
        this.timerAction = jpdlReader.readSingleAction(actionElement);
        this.dueDate = actionElement.attributeValue("duedate");
        if (this.dueDate == null) {
            jpdlReader.addWarning("due date not specified on create timer: " + actionElement.getPath());
        }
        this.repeat = actionElement.attributeValue("repeat");
        if (jpdlReader.readBoolean(this.repeat, false)) {
            this.repeat = this.dueDate;
        }
        this.transitionName = actionElement.attributeValue("transition");
        if (this.transitionName != null && this.repeat != null) {
            this.repeat = null;
            jpdlReader.addWarning("ignoring repeat on create timer with transition: " + actionElement.getPath());
        }
    }

    public void execute(ExecutionContext executionContext) throws Exception {
        JbpmContext jbpmContext = executionContext.getJbpmContext();
        if (jbpmContext == null) {
            throw new JbpmException("jbpm context unavailable");
        }
        SchedulerService schedulerService = jbpmContext.getServices().getSchedulerService();
        if (schedulerService == null) {
            throw new JbpmException("scheduler service unavailable");
        }
        Timer timer = this.createTimer(executionContext);
        schedulerService.createTimer(timer);
    }

    public String toString() {
        return "CreateTimerAction(" + this.timerName + ')';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Timer createTimer(ExecutionContext executionContext) {
        GraphElement graphElement;
        Timer timer = new Timer(executionContext.getToken());
        timer.setName(this.timerName);
        timer.setRepeat(this.repeat);
        if (this.dueDate != null) {
            Date dueDateDate;
            if (this.dueDate.startsWith("#{") || this.dueDate.startsWith("${")) {
                Date baseDate;
                int braceIndex = this.dueDate.indexOf(125);
                if (braceIndex == -1) {
                    throw new JbpmException("invalid due date, closing brace missing: " + this.dueDate);
                }
                String baseDateExpression = this.dueDate.substring(0, braceIndex + 1);
                Object result = JbpmExpressionEvaluator.evaluate(baseDateExpression, executionContext);
                if (result instanceof Date) {
                    baseDate = (Date)result;
                } else if (result instanceof Calendar) {
                    baseDate = ((Calendar)result).getTime();
                } else {
                    throw new JbpmException(baseDateExpression + " returned " + result + " instead of date or calendar");
                }
                String durationString = this.dueDate.substring(braceIndex + 1).trim();
                if (durationString.length() > 0) {
                    char durationSeparator = durationString.charAt(0);
                    if (durationSeparator != '+' && durationSeparator != '-') {
                        throw new JbpmException("invalid due date, '+' or '-' missing after expression: " + this.dueDate);
                    }
                    dueDateDate = new BusinessCalendar().add(baseDate, new Duration(durationString));
                } else {
                    dueDateDate = baseDate;
                }
            } else {
                dueDateDate = new BusinessCalendar().add(Clock.getCurrentTime(), new Duration(this.dueDate));
            }
            timer.setDueDate(dueDateDate);
        }
        timer.setAction(this.timerAction);
        timer.setTransitionName(this.transitionName);
        timer.setGraphElement(executionContext.getEventSource());
        timer.setTaskInstance(executionContext.getTaskInstance());
        Event event = this.getEvent();
        if (event != null && (graphElement = event.getGraphElement()) != null) {
            try {
                executionContext.setTimer(timer);
                graphElement.fireEvent("timer-create", executionContext);
            }
            finally {
                executionContext.setTimer(null);
            }
        }
        return timer;
    }

    public String getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(String dueDateDuration) {
        this.dueDate = dueDateDuration;
    }

    public String getRepeat() {
        return this.repeat;
    }

    public void setRepeat(String repeatDuration) {
        this.repeat = repeatDuration;
    }

    public String getTransitionName() {
        return this.transitionName;
    }

    public void setTransitionName(String transitionName) {
        this.transitionName = transitionName;
    }

    public String getTimerName() {
        return this.timerName;
    }

    public void setTimerName(String timerName) {
        this.timerName = timerName;
    }

    public Action getTimerAction() {
        return this.timerAction;
    }

    public void setTimerAction(Action timerAction) {
        this.timerAction = timerAction;
    }
}

